package com.zzsn.event.mapper;

import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公用mapper
 *
 * @author lkg
 * @date 2024/12/17
 */
@Mapper
public interface CommonMapper {

    /**
     * 栏目集合
     *
     * @param columnIds 栏目id集合
     * @author lkg
     * @date 2024/9/13
     */
    List<Node> columnList(@Param("columnIds") List<String> columnIds);

    /**
     * 项目集合
     *
     * @author lkg
     * @date 2024/9/13
     */
    List<Node> projectList();

    /**
     * 企业标签下的企业信用代码集合
     *
     * @param labelIds 企业标签id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> codesByLabels(@Param("labelIds") List<String> labelIds);

    List<KeyWordsPage> selectKeyWordsListById(@Param("subjectId") String subjectId);

    List<InfoSourceGroupPage> selectInfoSourceListById(@Param("subjectId") String subjectId);

    /**
     * 专题/事件绑定 关键词组数量
     *
     * @param idList 专题/事件id集合
     * @author lkg
     * @date 2024/12/18
     */
    List<SubjectPage> bindKeyWordsCountList(@Param("idList") List<String> idList);

    /**
     * 专题/事件绑定的信息源集合
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/4/24
     */
    List<SubjectInfoSourceLabelTypeVo> bindSourceList(@Param("subjectIds") List<String> subjectId);

    /**
     * 专题/事件绑定的信息源集合
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/4/24
     */
    List<SubjectInfoSourceLabelTypeVo> excludeSourceList(@Param("subjectIds") List<String> subjectId);

    /**
     * 模型列表
     *
     * @author lkg
     * @date 2024/12/18
     */
    List<ModelVO> modelList();

    /**
     * 专题下模型绑定的标签信息
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/12/20
     */
    List<LabelModelVo> subjectModelBindLabels(@Param("subjectIds") List<String> subjectIds);
}
