package com.zzsn.event.controller.common;

import com.zzsn.event.constant.Result;
import com.zzsn.event.es.EsService;
import com.zzsn.event.vo.CountVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 统计分析
 *
 * @author lkg
 * @date 2024/12/25
 */
@RestController
@RequestMapping("/statistical/analysis")
public class StatisticalAnalysisController {

    @Autowired
    private EsService esService;

    @GetMapping("/dataTrend")
    public Result<?> dataTrend(@RequestParam String subjectId,
                               @RequestParam(required = false) String startDate,
                               @RequestParam(required = false) String endDate){
        List<CountVO> subjectDatabaseByTime = esService.getSubjectDatabaseByTime(startDate, endDate, "month", subjectId, null, null);
        return Result.OK(subjectDatabaseByTime);
    }
}
