package com.zzsn.event.controller.infosource;


import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.GroupMainType;
import com.zzsn.event.service.IGroupMainTypeService;
import com.zzsn.event.vo.GroupMainTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Api(tags = "信息源组类别")
@RestController
@RequestMapping("/groupMainType")
public class GroupMainTypeController {

    @Autowired
    private IGroupMainTypeService groupTypeService;


    /**
     * 通过父级id列表查询
     *
     * @param subjectId
     * @return
     */
//    @AutoLog(value = "信息源组类别-通过父级id列表查询")
    @ApiOperation(value = "信息源组类别-通过父级id列表查询", notes = "信息源组类别-通过父级id列表查询")
    @GetMapping(value = "/listByParentId")
    public Result<?> listByParentId(@RequestParam(name = "subjectId", defaultValue = "0") String subjectId,
                                    @RequestParam(name = "parentId", defaultValue = "0") String parentId) {

        List<GroupMainTypeVo> allList = groupTypeService.listByParentId(parentId);
        return Result.OK(allList);
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
//    @AutoLog(value = "信息源组类别-通过id删除")
    @ApiOperation(value = "信息源组类别-通过id删除", notes = "信息源组类别-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        groupTypeService.deleteGroupType(id);
        return Result.OK("删除成功!");
    }
    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "信息源组类别-批量删除", notes = "信息源组类别-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        groupTypeService.deleteGroupTypeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功！");
    }
    /**
     * 添加
     *
     * @param groupMainType
     * @return
     */
    @ApiOperation(value = "信息源组类别-添加", notes = "信息源组类别-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody GroupMainType groupMainType) {

        return groupTypeService.addGroupType(groupMainType);
    }

    /**
     * 编辑
     *
     * @param groupMainType
     * @return
     */
    @ApiOperation(value = "信息源组类别-编辑", notes = "信息源组类别-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody GroupMainType groupMainType) {

        return groupTypeService.updateGroupType(groupMainType);
    }

    /**
     * 信息源组分类据源组树结构
     *
     * @return
     */
    @ApiOperation(value = "信息源组分类据源组树结构", notes = "信息源组分类据源组树结构")
    @GetMapping(value = "/getInfoGroupTypeTree")
    public Result<?> getInfoGroupTypeTree() {

        return groupTypeService.getInfoGroupTypeTree();
    }

    /**
     * 列表查询
     *
     * @param groupName
     * @return
     */
    @ApiOperation(value = "信息源组表-列表查询", notes = "信息源组表-列表查询")
    @GetMapping(value = "/sourceGroupPermissionQueryList")
    public Result<?> permissionQueryList(String groupName) {


        return groupTypeService.sourceGroupPermissionQueryList(groupName);
    }

    /**
     * 列表查询
     *
     * @param contain
     * @param subjectId
     * @return
     */
    @ApiOperation(value = "信息源组类别-列表查询", notes = "信息源组类别-列表查询")
    @GetMapping(value = "/rootListNoPage")
    public Result<?> queryPageListNoPage(@RequestParam(name = "contain", defaultValue = "false") Boolean contain,
                                         @RequestParam(name = "keywords", required = false) String keywords,
                                         @RequestParam(name = "subjectId", defaultValue = "0") String subjectId) {

        List<GroupMainTypeVo> allList = groupTypeService.allList(contain, subjectId,keywords);
        return Result.OK(allList);
    }
}
