package com.zzsn.event.vo.log;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.zzsn.event.enums.EnumHandlerStatus;
import com.zzsn.event.enums.EnumOperateType;
import com.zzsn.event.enums.EnumOperateWay;
import com.zzsn.event.enums.EnumSourceType;
import com.zzsn.event.vo.es.Subjectdatabase;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.apache.commons.collections4.CollectionUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * ES 索引data_lifecycle_log实体类<br>
 * 数据生命周期日志实体的主类
 *
 * @author 张宗涵
 * @date 2024/4/25
 */
@Getter
@Setter
@FieldNameConstants
public class DataLifecycleLog {
    public final static String INDEX_NAME = "data_lifecycle_log";
    /**
     * 资讯id
     */
    private String id;

    /**
     * 标题
     */
    private String title;

    /**
     * 原链接
     */
    private String sourceAddress;

    /**
     * 资讯唯一标识
     */
    private String uniqueCode;

    /**
     * 操作类型
     */
    private EnumOperateType operateType;

    /**
     * 操作方式
     */
    private EnumOperateWay operateWay;

    /**
     * 操作描述
     */
    private String operateDescription = null;

    /**
     * 处理情况{@link HandlerBody}
     */
    private HandlerBody handlerBody;

    /**
     * 操作用户
     */
    private String operateUser;

    /**
     * 专题 {@link Subject}
     */
    private Subject subject;

    /**
     * 操作模块 {@link Model}
     */
    private Model model;

    /**
     * 信息源信息 {@link Source}
     */
    private Source source;

    /**
     * 处理时间
     */
    private LocalDateTime processTime;

    /**
     * 服务信息 {@link Server}
     */
    private Server server;

    /**
     * 实时获取带yyyyMM的真实索引名称
     *
     * @return 真实索引名称indexName_yyyyMM
     */
    public static String getRealIndex() {
        return INDEX_NAME + "_" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM"));
    }

    /**
     * 生成人工审核是否通过日志实体
     */
    public static DataLifecycleLog createDataCheckLog(Subjectdatabase subjectdatabase, String operateUser, String sourceName, EnumHandlerStatus enumHandlerStatus) {
        final DataLifecycleLog log = handleCommonStagePart(subjectdatabase, operateUser, sourceName);
        log.getHandlerBody().setHandlerStatus(enumHandlerStatus);

        return log;
    }

    /**
     * 生成 人工操作 日志实体
     */
    public static DataLifecycleLog createManualOperateLog(Subjectdatabase subjectdatabase, String operateUser,EnumOperateWay enumOperateWay, String sourceName, List<String> labelNameList) {
        final DataLifecycleLog log = handleCommonManualPart(subjectdatabase, operateUser,enumOperateWay, sourceName);
        if (CollectionUtils.isNotEmpty(labelNameList)) {
            log.getHandlerBody().setHandlerResult(JSON.toJSONString(labelNameList));
        }

        return log;
    }

    /**
     * 生成 人工添加 日志实体
     */
    public static DataLifecycleLog createToSubjectLog(Subjectdatabase subjectdatabase, String operateUser){
        DataLifecycleLog log = new DataLifecycleLog();
        log.setUniqueCode(subjectdatabase.getUniqueCode());
        log.setOperateUser(operateUser);
        log.setOperateWay(EnumOperateWay.TO_SUBJECT_MANUAL_ADD);
        log.setOperateType(EnumOperateType.TO_SUBJECT);
        log.setProcessTime(LocalDateTime.now());
        log.setTitle(subjectdatabase.getTitle());
        log.setSourceAddress(subjectdatabase.getSourceAddress());

        final Subject subject = new Subject();
        subject.setSubjectName(subjectdatabase.getSubjectName());
        subject.setSubjectId(subjectdatabase.getSubjectId());
        log.setSubject(subject);

        final Server server = Server.getServer();
        log.setServer(server);

        final HandlerBody handlerBody = new HandlerBody();
        handlerBody.setSuccess(true);
        handlerBody.setHandlerStatus(EnumHandlerStatus.ADD);
        log.setHandlerBody(handlerBody);

        return log;
    }


    //生命周期阶段 的通用部分
    private static DataLifecycleLog handleCommonStagePart(Subjectdatabase subjectdatabase, String operateUser, String sourceName) {
        DataLifecycleLog log = new DataLifecycleLog();
        log.setUniqueCode(subjectdatabase.getUniqueCode());
        log.setOperateUser(operateUser);
        log.setOperateWay(EnumOperateWay.MANUAL_CHECK);
        log.setOperateType(EnumOperateType.DATA_CHECK);
        log.setProcessTime(LocalDateTime.now());
        log.setTitle(subjectdatabase.getTitle());
        log.setSourceAddress(subjectdatabase.getSourceAddress());

        final Source source = new Source();
        source.setSourceId(subjectdatabase.getSid());
        source.setSourceType(EnumSourceType.getByCode(subjectdatabase.getSource()));
        source.setSourceName(sourceName);
        log.setSource(source);

        final Subject subject = new Subject();
        subject.setSubjectName(subjectdatabase.getSubjectName());
        subject.setSubjectId(subjectdatabase.getSubjectId());
        log.setSubject(subject);

        final Server server = Server.getServer();
        log.setServer(server);

        final HandlerBody handlerBody = new HandlerBody();
        handlerBody.setSuccess(true);
        log.setHandlerBody(handlerBody);

        return log;
    }

    //人工操作的通用部分
    private static DataLifecycleLog handleCommonManualPart(Subjectdatabase subjectdatabase, String operateUser, EnumOperateWay enumOperateWay,String sourceName) {
        DataLifecycleLog log = new DataLifecycleLog();
        log.setUniqueCode(subjectdatabase.getUniqueCode());
        log.setOperateUser(operateUser);
        log.setOperateWay(enumOperateWay);
        log.setProcessTime(LocalDateTime.now());
        log.setTitle(subjectdatabase.getTitle());
        log.setSourceAddress(subjectdatabase.getSourceAddress());

        final Source source = new Source();
        source.setSourceId(subjectdatabase.getSid());
        source.setSourceType(EnumSourceType.getByCode(subjectdatabase.getSource()));
        source.setSourceName(sourceName);
        log.setSource(source);

        final Subject subject = new Subject();
        subject.setSubjectName(subjectdatabase.getSubjectName());
        subject.setSubjectId(subjectdatabase.getSubjectId());
        log.setSubject(subject);

        final Server server = Server.getServer();
        log.setServer(server);

        final HandlerBody handlerBody = new HandlerBody();
        handlerBody.setSuccess(true);
        log.setHandlerBody(handlerBody);

        return log;
    }

    /**
     * 生成日志拼接消息
     */
    public void wrapOperateDescription() {
    }

    /**
     * 检查唯一标识，如果为空则抛出异常
     */
    public final void checkUniqueCodeBlank() throws IllegalArgumentException {
        Assert.isTrue(StrUtil.isNotBlank(getUniqueCode()), "资讯唯一标识uniqueCode为空");
    }
}
