package com.zzsn.event.mapper;

import com.zzsn.event.entity.EventExtractTask;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.vo.EventExtractTaskVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author lenovo
 * @description 针对表【event_extract_task(事件抽取任务表)】的数据库操作Mapper
 * @createDate 2024-09-13 11:31:47
 * @Entity com.zzsn.event.entity.EventExtractTask
 */
@Mapper
public interface EventExtractTaskMapper extends BaseMapper<EventExtractTask> {

    /**
     * 事件抽取任务信息列表
     *
     * @param projectId  项目id
     * @param searchWord 搜索词
     * @param taskName   任务名称
     * @param startTime  开始时间
     * @param endTime    结束时间
     * @param offset     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/9/13
     */
    List<EventExtractTaskVO> pageList(@Param("projectId") String projectId, @Param("searchWord") String searchWord,
                                      @Param("taskName") String taskName, @Param("startTime") String startTime, @Param("endTime") String endTime,
                                      @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 事件抽取任务信息总数量
     *
     * @param projectId  项目id
     * @param searchWord 搜索词
     * @param taskName   任务名称
     * @param startTime  开始时间
     * @param endTime    结束时间
     * @author lkg
     * @date 2024/9/13
     */
    Long totalCount(@Param("projectId") String projectId, @Param("searchWord") String searchWord,
                    @Param("taskName") String taskName, @Param("startTime") String startTime, @Param("endTime") String endTime);
}




