package com.zzsn.event.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.EventClb;
import com.zzsn.event.entity.EventTag;
import com.zzsn.event.entity.EventTagClb;
import com.zzsn.event.mapper.EventClbMapper;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.service.IEventTagClbService;
import com.zzsn.event.service.IEventTagService;
import com.zzsn.event.vo.EventVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 同步克虏宝事件相关信息，因为查询事件时候关联的有其它相关表，并且相关表的字段也参与过滤条件
 * @author wangFeng
 * @date 2024/10/15 13:51
 */
@Slf4j
@Component
public class SynClbEventDataTask {
    @Resource
    private IEventService eventService;
    @Resource
    private IEventTagService eventTagService;

    @Resource
    private EventClbMapper eventClbMapper;
    @Resource
    private IEventTagClbService eventTagClbService;

    @Value("${scheduling.yjzxEnable:false}")
    Boolean yjzxEnable;

    /**
     * 同步克虏宝中事件信息到研究中心数据库
     */
    @Scheduled(cron = "0 15 0/1 * * ?")
    public void synEventData () {
        if(!yjzxEnable){
            return;
        }
        log.info("同步克虏宝中事件信息到研究中心数据库开始");
        //LambdaQueryWrapper<Event> queryWrapper = Wrappers.lambdaQuery();
        //queryWrapper.eq(Event::getFacePublic,1).eq(Event::getPublishStatus,1);
        List<Event> list = eventService.list();
        for (Event event : list) {
            try{
                // 克虏宝事件表
                String eventId = event.getId();
                EventClb eventClb = eventClbMapper.selectById(eventId);
                if (eventClb != null) {
                    LambdaUpdateWrapper<Event> lambdaUpdateWrapper = Wrappers.lambdaUpdate(Event.class).eq(Event::getId, eventId)
                            .set(Event::getRelationEvents, eventClb.getRelationEvents()) // 事件关联事件
                            .set(Event::getEventLabel, eventClb.getEventLabel()) // 事件表中打的标签
                            // total_hot根据所有事件定时统计，这个使用研究中心自己的
                            ;
                    eventService.update(lambdaUpdateWrapper);
                    // 事件标签表
                    EventTagClb eventTagClb = eventTagClbService.getOne(new LambdaQueryWrapper<EventTagClb>()
                            .eq(EventTagClb::getEventId, eventId)
                            .last(" limit 1"));
                    LambdaUpdateWrapper<EventTag> tagUpdateWrapper = Wrappers.lambdaUpdate(EventTag.class)
                            .eq(EventTag::getEventId, eventId)
                            .set(EventTag::getExtractIndustryTag, eventTagClb.getExtractIndustryTag())
                            .set(EventTag::getExtractCompanyTag, eventTagClb.getExtractCompanyTag())
                            .set(EventTag::getExtractPersonTag, eventTagClb.getExtractPersonTag())
                            .set(EventTag::getExtractSentimentTag, eventTagClb.getExtractSentimentTag())
                            .set(EventTag::getExtractKeywordsTag, eventTagClb.getExtractKeywordsTag())
                            .set(EventTag::getExtractLocationTag, eventTagClb.getExtractLocationTag())
                            .set(EventTag::getExtractTimeTag, eventTagClb.getExtractTimeTag());
                    eventTagService.update(tagUpdateWrapper);
                }
            }catch (Exception e){
                log.error("同步克虏宝中事件信息到研究中心数据库失败：{}", e);
            }
        }
        log.info("同步克虏宝中事件信息到研究中心数据库结束");
    }
}
