package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.vo.DirectBindInfoVO;
import com.zzsn.event.vo.SearchEnginesVo;
import com.zzsn.event.vo.SubjectCondition;
import com.zzsn.event.vo.SubjectPage;

import java.util.List;

/**
 * @Description: 专题表
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
public interface SubjectService extends IService<Subject> {

    /**
     * 分页列表
     *
     * @param subjectCondition 查询条件
     * @param pageNo           当前页
     * @param pageSize         每页返回条数
     * @author lkg
     * @date 2024/12/18
     */
    Page<SubjectPage> pageList(SubjectCondition subjectCondition, Integer pageNo, Integer pageSize);

    /**
     * 新增专题
     *
     * @param subjectPage 参数
     */
    Subject saveMain(SubjectPage subjectPage);

    /**
     * 编辑
     *
     * @param subjectPage 参数
     */
    void updateMain(SubjectPage subjectPage);

    /**
     * 删除
     *
     * @param subjectId 专题/事件id
     */
    void deleteMain(String subjectId);

    /**
     * 专题详情
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/12/18
     */
    SubjectPage getSubjectById(String subjectId);

    /**
     * 专题直接绑定信息源-批量
     *
     * @param directBindInfoVO 参数封装
     * @author lkg
     * @date 2024/4/24
     */
    void directBindInfoSource(DirectBindInfoVO directBindInfoVO);

    /**
     * 专题直接解绑信息源-批量
     *
     * @param directBindInfoVO 参数封装
     * @author lkg
     * @date 2024/4/24
     */
    void directRemoveInfoSource(DirectBindInfoVO directBindInfoVO);

    /**
     * 删除专题下已屏蔽的信息源(即恢复绑定关系)
     *
     * @param subjectId    专题id
     * @param infoSourceId 信息源id
     * @author lkg
     * @date 2024/5/7
     */
    void removeUnBindInfoSource(String subjectId, String infoSourceId);

    /**
     * 专题关键词绑定
     */
    void keyWordsBind(SubjectPage subjectPage);

    /**
     * 删除关键词的绑定
     */
    void deleteBindKeyWords(SubjectPage subjectPage);

    /**
     * 专题搜索引擎绑定
     */
    void searchEngineBind(SubjectPage subjectPage);

    /**
     * 获取专题绑定的搜索引擎列表
     */
    List<SearchEnginesVo> bindSearchEngineList(SearchEnginesVo searchEnginesVo);

    /**
     * 专题模型绑定
     *
     * @param subjectPage 参数
     * @author lkg
     * @date 2024/12/18
     */
    Result<?> modelBind(SubjectPage subjectPage);

    Result<?> checkIsBreak(SubjectPage subjectPage);

    /**
     * 发送消息
     */
    void send(String subjectId, String status);
}
