package com.zzsn.event.vo;

import lombok.Data;

import java.util.List;

@Data
public class EventDataCondition {

    private String id;

    //专题id
    private String subjectId;

    //文章链接
    private String url;

    //搜索时，全部情况下，，搜索传值
    private String search;

    //专题标题
    private String title;

    //专题摘要
    private String summary;

    //内容
    private String content;

    //作者
    private String author;

    //发布时间
    private String publishDate;

    //来源
    private String origin;

    //得分
    private String score;

    //企业名称
    private String enterpriseName;

    //倾向性
    private String orientation;

    //风险类型
    private String riskType;

    //企业性质
    private String enterpriseNature;

    //区域
    private String area;

    //行业
    private String trade;

    //信息类型
    private String InfoType;

    //专题库类型
    private String libraryType;

    //ids
    private List<String> ids;

    //置顶标识（0取消置顶 1置顶）
    private Integer type;

    private String sourceAddress;

    //开始时间
    private String startTime;

    //结束时间
    private String endTime;

    //倾向性（前端交互参数约定 0：中性  1：负面  2：正面）
    private Integer tendency;

    //专题库类型(1：政策；2：领导讲话；3：专家观点；4：企业案例)
    private Integer classificationType;

    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private List<Integer> checkStatusList;
    private Integer checkStatus;

    //删除标记(1:删除；0:保留)
    private Integer deleteFlag = 0;

    //国家
    private String countryIds;

    //城市
    private String cityIds;

    //企业
    private String enterpriseIds;

    //人物
    private String characterIds;


    //字段
    private String fields;


    //操作类型 add .update
    private String action;

    //日期最大值
    private String maxValue;

    //关键词检索范围 1标题  2正文 3 全部
    private  Integer searchScope;
    //精确度("精确"| --)
    private String searchAccuracy;
    //数据所在的索引名称
    private String index;

    private String operateStartTime;
    private String operateEndTime;
    private String labelName;
}
