package com.zzsn.event.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.SysLoginModel;
import com.zzsn.event.service.EventLoginService;
import com.zzsn.event.util.RedisUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author wangFeng
 * @date 2024/10/22 14:29
 */
@Slf4j
@Service
public class EventLoginServiceImpl implements EventLoginService {
    @Value("${spring.profiles.active:dev}")
    private String evn;
    @Value("${clbLogin.url}")
    private String loginUrl;
    //@Resource
    //private RedisUtil redisUtil;

    private Integer successCode = 200;
    public static final String CACHE_KEY = "event:sso:";
    private Map<String, Map<String, Object>> CACHE_MAP = new HashMap<>(16);

    @Override
    public Result<?> loginBS(SysLoginModel sysLoginModel) {
        String username = sysLoginModel.getUsername();
        String cacheKey = CACHE_KEY + evn + ":" +username;
        if (CACHE_MAP.containsKey(cacheKey)) {
            Map<String, Object> map = CACHE_MAP.get(cacheKey);
            SysLoginModel sysLoginModelCache = (SysLoginModel) map.get("sysLoginModel");
            if (sysLoginModelCache.getPassword().equals(sysLoginModel.getPassword())
                    && sysLoginModelCache.getCaptcha().equals(sysLoginModel.getCaptcha())
                    && sysLoginModelCache.getCheckKey().equals(sysLoginModel.getCheckKey())) {
                LocalDateTime cacheDate = (LocalDateTime) map.get("cacheDate");
                LocalDateTime now = LocalDateTime.now();
                long minutesDiff = ChronoUnit.MINUTES.between(cacheDate, now);
                if (minutesDiff < 10) {
                    // 使用缓存
                    Result loginResult = (Result) map.get("loginResult");
                    return loginResult;
                }
            }
            //信息变了就需要重新登录
            CACHE_MAP.remove(cacheKey);
        }
        return doClbLogin(sysLoginModel);
    }

    @Override
    public void redoLogin() {
//        String cacheKey = CACHE_KEY + evn + ":*";
//        ScanOptions options = ScanOptions.scanOptions().match(cacheKey).count(100).build();
//        Cursor<String> scan = redisUtil.getRedisTemplate().scan(options);
//        while (scan.hasNext()){
//            String next = scan.next();
//            Map<String, Object> cacheMap = (Map<String, Object>) redisUtil.get(next);
//            SysLoginModel sysLoginModelCache = (SysLoginModel) cacheMap.get("sysLoginModel");
//            doClbLogin(sysLoginModelCache);
//        }
        if (CACHE_MAP != null) {
            Set<String> keys = CACHE_MAP.keySet();
            for (String key : keys) {
                Map<String, Object> map = CACHE_MAP.get(key);
                SysLoginModel sysLoginModelCache = (SysLoginModel) map.get("sysLoginModel");
                doClbLogin(sysLoginModelCache);
            }
        }
    }

    /**
     * 去克虏宝登录
     * @param sysLoginModel
     */
    public Result<?> doClbLogin(SysLoginModel sysLoginModel){
        Result<?> bean;
        try {
            String body = HttpRequest.post(loginUrl)
                    .header("content-type", "application/json;charset=UTF-8")
                    .body(JSONObject.toJSONString(sysLoginModel))
                    .execute().body();
            bean = JSONObject.parseObject(body, Result.class);
            if (successCode.equals(bean.getCode())) {
                String username = sysLoginModel.getUsername();
                String cacheKey = CACHE_KEY  + evn + ":" + username;
                // 调用成功
                Map<String, Object> cacheMap = new HashMap<>(2);
                cacheMap.put("sysLoginModel", sysLoginModel);
                cacheMap.put("loginResult", bean);
                cacheMap.put("cacheDate", LocalDateTime.now());
                CACHE_MAP.put(cacheKey, cacheMap);
                log.info("缓存用户结束："+cacheKey);
            }
        } catch (Exception e) {
            bean = Result.FAIL();
        }
        return bean;
    }
}
