package com.zzsn.event.util;


import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;

import java.util.HashMap;
import java.util.Map;

/**
 * token util
 * 
 * @author yanrj 2018-7-17 13:17:11
 *
 */
public class TokenUtil {

	/**
	 * createToken
	 * 
	 * @param userId
	 * @return
	 * @throws Exception
	 */
	public static String createToken(String userId ,String timeStr) throws Exception {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("alg", "HS256");
		map.put("typ", "JWT");
		map.put("timeStr", timeStr);
		String token = JWT.create().withHeader(map)// header
				.withClaim("userId", userId)// payload
				.withClaim("timeStr", timeStr)// payload
				.sign(Algorithm.HMAC256("secret"));
		return token;
	}

	/**
	 * verifyToken
	 * 
	 * @param token
	 * @return
	 * @throws Exception
	 */
	public static String verifyToken(String token){
		JWTVerifier verifier = JWT.require(Algorithm.HMAC256("secret")).build();
		DecodedJWT jwt = verifier.verify(token);
		Map<String, Claim> claims = jwt.getClaims();
		return claims.get("userId").asString();
	}
	
	/**
	 * get token time String
	 * 
	 * @param token
	 * @return
	 * @throws Exception
	 */
	public static String getTimeStrToken(String token) throws Exception {
		JWTVerifier verifier = JWT.require(Algorithm.HMAC256("secret")).build();
		DecodedJWT jwt = verifier.verify(token);
		Map<String, Claim> claims = jwt.getClaims();
		return claims.get("timeStr").asString();
	}

	/**
	 * main
	 * 
	 * @param args
	 * @throws Exception
	 */
//	public static void main(String[] args) throws Exception {
////		Long startTime = System.currentTimeMillis();
//		String token = createToken("190","1578276314015");
//		System.out.println(token);
////		Long midTime = System.currentTimeMillis();
////		System.out.println(midTime - startTime + "ms");
////		String userId = verifyToken(token);
////		System.out.println(userId);
////		Long endTime = System.currentTimeMillis();
////		System.out.println(endTime - midTime + "ms");
//		System.out.println( verifyToken(token) );
//		System.out.println( getTimeStrToken(token) );
//	}

}
