package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 频道标签映射表
 * @Author: jeecg-boot
 * @Date:   2023-03-14
 * @Version: V1.0
 */
@Data
@TableName("clb_channel_label_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="clb_channel_label_map对象", description="频道标签映射表")
public class ClbChannelLabelMap implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**标签类别*/
	@Excel(name = "标签id", width = 15)
    @ApiModelProperty(value = "标签id")
    private String labelId;
	/**类别id*/
	@Excel(name = "类别id", width = 15)
    @ApiModelProperty(value = "类别id")
    private String labelTypeId;
	/**类别标识*/
	@Excel(name = "类别标识", width = 15)
    @ApiModelProperty(value = "类别标识")
    private String labelTypeMark;
	/**标签分类类别*/
	@Excel(name = "标签分类类别", width = 15)
    @ApiModelProperty(value = "标签分类类别")
    private String labelType;
	/**频道id*/
	@Excel(name = "频道id", width = 15)
    @ApiModelProperty(value = "频道id")
    private String channelId;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
    /**类别(1:标签类别 2：标签)*/
    @Excel(name = "类别", width = 15)
    @ApiModelProperty(value = "类别")
    private Integer type;

    /**标签类别名称*/
    @TableField(exist = false)
    private String labelName;
}
