package com.zzsn.event.mapper;

import com.zzsn.event.entity.EventExtract;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.vo.EventExtractVO;
import com.zzsn.event.vo.EventFrontVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author lenovo
 * @description 针对表【event_extract(事件)】的数据库操作Mapper
 * @createDate 2024-09-07 18:00:28
 * @Entity com.zzsn.event.entity.EventExtract
 */
@Mapper
public interface EventExtractMapper extends BaseMapper<EventExtract> {

    /**
     * 伪事件信息列表
     *
     * @param searchWord  搜索词
     * @param eventName   事件名称
     * @param eventType   时间分类
     * @param startTime   开始时间
     * @param endTime     结束时间
     * @param checkStatus 审核状态(2-不通过;1-通过;0-待审核)
     * @param offset      偏移量
     * @param pageSize    返回条数
     * @author lkg
     * @date 2024/9/9
     */
    List<EventExtractVO> pageList(@Param("taskId") String taskId, @Param("searchWord") String searchWord,
                                  @Param("eventName") String eventName,
                                  @Param("startTime") String startTime, @Param("endTime") String endTime,
                                  @Param("eventType") String eventType, @Param("checkStatus") Integer checkStatus,
                                  @Param("column") String column, @Param("sortType") String sortType,
                                  @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 伪事件信息总数量
     *
     * @param searchWord  搜索词
     * @param eventName   事件名称
     * @param eventType   时间分类
     * @param startTime   开始时间
     * @param endTime     结束时间
     * @param checkStatus 审核状态(2-不通过;1-通过;0-待审核)
     * @author lkg
     * @date 2024/9/9
     */
    Long totalCount(@Param("taskId") String taskId, @Param("searchWord") String searchWord,
                    @Param("eventName") String eventName,
                    @Param("startTime") String startTime, @Param("endTime") String endTime,
                    @Param("eventType") String eventType, @Param("checkStatus") Integer checkStatus);


    /**
     * 自动追踪事件列表-门户
     *
     * @param projectId  项目id
     * @param eventName  事件名称
     * @param eventTypes 事件分类id集合
     * @param offset     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/9/9
     */
    List<EventFrontVO> frontDigPageList(@Param("projectId") String projectId, @Param("eventName") String eventName,
                                     @Param("eventTypes") List<String> eventTypes,
                                     @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 自动追踪事件总数量-门户
     *
     * @param projectId  项目id
     * @param eventName  事件名称
     * @param eventTypes 事件分类id集合
     * @author lkg
     * @date 2024/9/9
     */
    Long frontDigTotalCount(@Param("projectId") String projectId, @Param("eventName") String eventName,
                         @Param("eventTypes") List<String> eventTypes);
}




