package com.zzsn.event.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zs
 * @Description 信息源/信息源组 枚举
 * @since 2021/12/9
 */
public enum BindTypeEnum {


    INFO_SOURCE(1,"绑定的通用信息源"),

    INFO_SOURCE_GROUP(2,"绑定的通用信息源组"),

    EXCLUDE_INFO_SOURCE(3,"排除的信息源"),

    EXCLUDE_INFO_SOURCE_GROUP(4,"排除的信息源组"),

    DIRECTIONA_INFO_SOURCE_GROUP(5,"定向的信息源组"),
    DIRECTIONA_INFO_SOURCE(6,"定向的信息源"),
    INFO_SOURCE_LABEL(12,"通用信息源标签"),
    EXCLUDE_INFO_SOURCE_LABEL(14,"排除信息源标签"),
    DIRECTIONA_INFO_SOURCE_LABEL(15,"定向信息源标签")
    ;

    private Integer value;
    private String des;

    BindTypeEnum(int value, String des) {
        this.value = value;
        this.des = des;
    }

    public Integer getvalue() {
        return value;
    }

    public String getDes() {
        return des;
    }



    //定向、通用、屏蔽信息源组类型返回
    public static List<Integer> getInfoSourceGroupType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
        values.add(BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        return values;
    }
    //定向、通用、屏蔽信息源类型返回
    public static List<Integer> getInfoSourceType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_SOURCE.getvalue());
        values.add(BindTypeEnum.EXCLUDE_INFO_SOURCE.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_INFO_SOURCE.getvalue());
        return values;
    }
    //定向、通用、屏蔽 标签类型返回
    public static List<Integer> getInfoSourceLabelType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_SOURCE_LABEL.getvalue());
        values.add(BindTypeEnum.EXCLUDE_INFO_SOURCE_LABEL.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_INFO_SOURCE_LABEL.getvalue());
        return values;
    }



    public static BindTypeEnum getEnumByValue(Integer value) {
        for (BindTypeEnum bindTypeEnum : BindTypeEnum.values()) {
            if (bindTypeEnum.getvalue().equals(value)) {
                return bindTypeEnum;
            }
        }
        return null;
    }
}
