package com.zzsn.event.service.impl;


import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.SubjectKeywordsGroupRelation;
import com.zzsn.event.mapper.SubjectKeywordsGroupRelationMapper;
import com.zzsn.event.service.SubjectKeywordsGroupRelationService;
import org.springframework.stereotype.Service;

/**
 * @Description: 数据库关键词过滤配置
 * @Author: jeecg-boot
 * @Date:   2023-08-12
 * @Version: V1.0
 */
@Service
public class SubjectKeywordsGroupRelationServiceImpl extends ServiceImpl<SubjectKeywordsGroupRelationMapper, SubjectKeywordsGroupRelation> implements SubjectKeywordsGroupRelationService {

    @Override
    public Result<?> add(SubjectKeywordsGroupRelation subjectKeywordsGroupRelation) {

        if (StrUtil.isNotBlank(subjectKeywordsGroupRelation.getSubjectId()) &&
                StrUtil.isNotBlank(subjectKeywordsGroupRelation.getRelationType()) &&
                StrUtil.isBlank(subjectKeywordsGroupRelation.getKeywordsGroupIds()) &&
                StrUtil.isBlank(subjectKeywordsGroupRelation.getExpressionStr())
        ){
            //只有关键词和绑定类型的时候 删除对应关系
            super.remove(Wrappers.<SubjectKeywordsGroupRelation>lambdaQuery()
                    .eq(SubjectKeywordsGroupRelation::getSubjectId,subjectKeywordsGroupRelation.getSubjectId())
                    .eq(SubjectKeywordsGroupRelation::getRelationType,subjectKeywordsGroupRelation.getRelationType())
            );
            return Result.OK();
        }

        if (StrUtil.isBlank(subjectKeywordsGroupRelation.getSubjectId()) ||
                StrUtil.isBlank(subjectKeywordsGroupRelation.getKeywordsGroupIds()) ||
                StrUtil.isBlank(subjectKeywordsGroupRelation.getRelationType()) ||
                StrUtil.isBlank(subjectKeywordsGroupRelation.getExpressionStr())) {
           return Result.FAIL("请检查参数");
        }
        super.remove(Wrappers.<SubjectKeywordsGroupRelation>lambdaQuery()
                .eq(SubjectKeywordsGroupRelation::getSubjectId,subjectKeywordsGroupRelation.getSubjectId())
                .eq(SubjectKeywordsGroupRelation::getRelationType,subjectKeywordsGroupRelation.getRelationType())
        );
        super.save(subjectKeywordsGroupRelation);
        return Result.OK(subjectKeywordsGroupRelation);
    }
}
