package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * Description: 文件操作详情表
 * Author: EDY
 * Date: 2023/7/26
 */
@Data
@Accessors(chain = true)
@TableName("clb_file_operation_log_details")
@ApiModel(value="clb_file_operation_log_details对象", description="文件操作详情表")
public class ClbFileOperationLogDetails {
    /** 唯一标识 */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "唯一标识")
    private String id ;
    /** 主表id */
    @ApiModelProperty(value = "主表id")
    private String fileOperationId ;
    /** 处理结果，0成功1失败 */
    @ApiModelProperty(value = "处理结果，0成功1失败")
    private Integer operationStatus = 0;
    /** 资讯来源 */
    @ApiModelProperty(value = "资讯来源")
    private String origin ;
    /** 资讯标题 */
    @ApiModelProperty(value = "资讯标题")
    private String title ;
    /** 资讯地址 */
    @ApiModelProperty(value = "资讯地址")
    private String sourceAddress ;
    /** 失败原因 */
    @ApiModelProperty(value = "失败原因")
    private String causeBy ;
    /** 创建时间 */
    @ApiModelProperty(value = "创建时间")
    private Date createTime ;
    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String remark ;
}
