package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 专题-字典关系表
* @TableName subject_dict_map
*/
@Data
@TableName("subject_dict_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SubjectDictMap implements Serializable {

    /**
    * 主键id
    */
    @TableId("id")
    private String id;
    /**
    * 专题id
    */
    @TableField("subject_id")
    private String subjectId;
    /**
    * 字典id
    */
    @TableField("dict_id")
    private String dictId;
    /**
    * 创建人
    */
    @TableField("create_by")
    private String createBy;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @TableField("create_time")
    private Date createTime;

}
