package com.zzsn.event.xxljob.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: xxl_job_info
 * @Author: zhang ya nuo
 * @Date: 2021-06-09
 * @Version: V1.0
 */
@Data
@TableName("xxl_job_info")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "xxl_job_info对象", description = "xxl_job_info")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class XxlJobInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 执行器主键ID
     */
    @ApiModelProperty(value = "执行器主键ID")
    private Long jobGroup;
    /**
     * 任务执行CRON
     */
    @ApiModelProperty(value = "任务执行CRON")
    private String jobCron;
    /**
     * jobDesc
     */
    @ApiModelProperty(value = "jobDesc")
    private String jobDesc;
    /**
     * addTime
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "addTime")
    private Date addTime;
    /**
     * updateTime
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "updateTime")
    private Date updateTime;
    /**
     * 作者
     */
    @ApiModelProperty(value = "作者")
    private String author;
    /**
     * 报警邮件
     */
    @ApiModelProperty(value = "报警邮件")
    private String alarmEmail;
    /**
     * 执行器路由策略
     */
    @ApiModelProperty(value = "执行器路由策略")
    private String executorRouteStrategy;
    /**
     * 执行器任务handler
     */
    @ApiModelProperty(value = "执行器任务handler")
    private String executorHandler;
    /**
     * 执行器任务参数
     */
    @ApiModelProperty(value = "执行器任务参数")
    private String executorParam;
    /**
     * 阻塞处理策略
     */
    @ApiModelProperty(value = "阻塞处理策略")
    private String executorBlockStrategy;
    /**
     * 任务执行超时时间，单位秒
     */
    @ApiModelProperty(value = "任务执行超时时间，单位秒")
    private Integer executorTimeout;
    /**
     * 失败重试次数
     */
    @ApiModelProperty(value = "失败重试次数")
    private Integer executorFailRetryCount;
    /**
     * GLUE类型
     */
    @ApiModelProperty(value = "GLUE类型")
    private String glueType;
    /**
     * GLUE源代码
     */
    @ApiModelProperty(value = "GLUE源代码")
    private String glueSource;
    /**
     * GLUE备注
     */
    @ApiModelProperty(value = "GLUE备注")
    private String glueRemark;
    /**
     * GLUE更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "GLUE更新时间")
    private Date glueUpdatetime;
    /**
     * 子任务ID，多个逗号分隔
     */
    @ApiModelProperty(value = "子任务ID，多个逗号分隔")
    private String childJobid;
    /**
     * 调度状态：0-停止，1-运行
     */
    @ApiModelProperty(value = "调度状态：0-停止，1-运行")
    private Integer triggerStatus;
    /**
     * 上次调度时间
     */
    @ApiModelProperty(value = "上次调度时间")
    private Long triggerLastTime;
    /**
     * 下次调度时间
     */
    @ApiModelProperty(value = "下次调度时间")
    private Long triggerNextTime;
    /**
     * 关联的信息源编码
     */
    @ApiModelProperty(value = "关联的信息源编码")
    private String infoSourceCode;
}
