package com.zzsn.event.neo4j.service;


import cn.hutool.core.util.StrUtil;
import com.zzsn.event.constant.Result;
import com.zzsn.event.neo4j.util.Neo4jUtil;
import com.zzsn.event.neo4j.vo.GraphInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Struct;

@Slf4j
@Service
public class AtlasService {

    @Autowired
    Neo4jUtil neo4jUtil;

    public Result<?> test(String sql , String databaseName) {
        GraphInfo nodeAndLink = neo4jUtil.getNodeAndLink(sql,databaseName);
        return Result.OK(nodeAndLink);
    }
    public Result<?> test1(String name, String databaseName) {
        StringBuilder a  = new StringBuilder("MATCH p=(n)-[r]->(m) ") ;

        if (StrUtil.isNotBlank(name)){
            a.append("WHERE n.entity_id =~ '.*"+name+".*' " +
                    "   OR m.entity_id =~ '.*"+name+".*' " +
                    "   OR TYPE(r) =~ '.*"+name+".*' " );
        }
                a.append("RETURN p, n, m ");
                a.append("LIMIT 200");


        GraphInfo nodeAndLink = neo4jUtil.getNodeAndLink(a.toString(),databaseName);
        return Result.OK(nodeAndLink);
    }
    public Result<?> getAtlasBysubjectId(String subjectId) {
        GraphInfo nodeAndLink = neo4jUtil.getNodeAndLink("MATCH p=(n)-->(m)  RETURN p,n,m LIMIT 200","lgragsj"+subjectId);
        return Result.OK(nodeAndLink);
    }

    public Result<?> getAtlasBysubjectIdAndName(String subjectId, String name) {
        GraphInfo nodeAndLink = neo4jUtil.getNodeAndLink(
                "MATCH (n)-[r]->(m) " +
                        "WHERE n.entity_id =~ '.*"+name+".*' OR " +
                        "m.entity_id =~ '.*"+name+".*' OR " +
                        "TYPE(r) =~ '.*"+name+".*'  " +
                        "RETURN r, n, m  LIMIT 200"
                ,"lgragsj"+subjectId);
        return Result.OK(nodeAndLink);
    }
    public Result<?> getAtlasBysubjectIdAndNamePath(String subjectId, String name) {
        GraphInfo nodeAndLink = neo4jUtil.getNodeAndLink(
                "MATCH p=(n)-[r]->(m) " +
                        "WHERE n.name =~ '.*"+name+".*' " +
                        "   OR m.name =~ '.*"+name+".*' " +
                        "   OR TYPE(r) =~ '.*"+name+".*' " +
                        "RETURN p, n, m " +
                        "LIMIT 200"
                ,"lgragsj"+subjectId);
        return Result.OK(nodeAndLink);
    }


}
