package com.zzsn.event.vo;

import lombok.Data;

import java.util.List;

/**
 * @author lkg
 * @description: 企业查询条件封装类
 * @date 2023/1/4
 */
@Data
public class EnterpriseCondition {

    /**
     * subjectId、additionType为用于专题绑定的参数
     */
    private String subjectId;
    private Integer additionType;

    /**
     * 统一社会信用代码
     */
    private String socialCreditCode;

    /**
     * 股票代码代码
     */
    private String securitiesCode;
    /**
     * 名称
     */
    private String name;
    /**
     * 组织机构代码
     */
    private String organizationCode;
    /**
     * 所属省份
     */
    private String province;
    /**
     * 状态
     */
    private Integer status;
    /**
     * 关联标签id
     */
    private String labelId;

    /**
     * 关联标签id列表
     */
    private List<String> labelIds;
    /**
     * 关联标签id列表长度
     */
    private Integer labelIdsCount;
    /**
     * 所属行业id
     */
    private String industryId;

    /**
     * 是否有财务数据，0是，1否
     */
    private Integer hasFinancialData;

    /**
     * 是否有基本信息，0是，1否
     */
    private Integer hasBase;

    /**
     * 是否有高管信息，0是，1否
     */
    private Integer hasMan;


    /**
     * 是否有企业研报，0是，1否
     */
    private Integer hasYb;
    /**
     * 是否有企业年报，0是，1否
     */
    private Integer hasNb;
    /**
     * 是否有企业动态，0是，1否
     */
    private Integer hasDt;
    /**
     * 是否有企业公告，0是，1否
     */
    private Integer hasGg;
    /**
     * 是否上市--针对上市标签
     */
    private Integer listed;
    /**
     * 关联标签id列表
     */
    private String startTime;
    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 标签信息集合
     */
    private List<LabelVO> labelList;

    private Integer pageNo = 1;
    private Integer pageSize = 10;
    /**
     * 不分页标识：不为null时做不分页查询，用于产业链全选关联企业（此时需查询到条件下所有企业数据）
     */
    private Integer noPage;

}
