package com.zzsn.event.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ImageUtil {

	@Value("${util.getUrlPath:https://clb.ciglobal.cn/clb-api/common/getUrlByBase64Data}")
	private String getUrlPath;

	/**
	 * base64图片转url
	 * @param html
	 */
	public String changeBase64ToUrl(String html){
		try {
			Document htmlDoc = Jsoup.parse(html);
			Elements imgs = htmlDoc.select("img"); // 获取所有的<img>标签
			boolean flag = false;
			for (Element img : imgs) {
				// 获取src属性
				String baseData = img.attr("src");
				if (baseData!=null && baseData.startsWith("data:image/")){
					//base64图片，需要转为url存储
					String post = HttpUtil.post(getUrlPath, baseData);
					JSONObject jsonObject = JSON.parseObject(post);
					if(jsonObject.getInteger("code") == 200){
						log.info("base64图片转url成功:{}", jsonObject.getString("result"));
						img.attr("src", jsonObject.getString("result"));
						flag = true;
					}
				}
			}
			if(flag){
				html = htmlDoc.html();
			}
		}catch (Exception e){
			log.error("base64图片转url失败:{}", e.getMessage());
		}
		return html;
	}
}