package com.zzsn.event.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.clb.common.model.task.dto.titr.KeyWordsDTO;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.CodePrefixEnum;
import com.zzsn.event.mapper.KeyWordsMapper;
import com.zzsn.event.service.*;
import com.zzsn.event.util.CodeGenerateUtil;
import com.zzsn.event.util.RedisUtil;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.util.user.AuthUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.KeywordsVO;
import com.zzsn.event.vo.SubjectKeywordsMap;
import com.zzsn.event.xxljob.service.IXxlJobInfoService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.checkerframework.checker.units.qual.K;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Description: 关键词管理
 * @Author: jeecg-boot
 * @Date: 2021-11-26
 * @Version: V1.0
 */
@Service
public class KeyWordsServiceImpl extends ServiceImpl<KeyWordsMapper, KeyWords> implements IKeyWordsService {

    @Autowired
    private ISubjectKeywordsMapService subjectKeywordsMapService;
    @Autowired
    private IKeywordsTypeMapService keywordsTypeMapService;
    @Autowired
    private IKeywordsTypeService keywordsTypeService;
    @Autowired
    private IXxlJobInfoService xxlJobInfoService;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ConfigurationMessageService configurationMessageService;
    @Autowired
    private SubjectKeywordsGroupRelationService subjectKeywordsGroupRelationService;

    @Resource
    private KafkaTemplate<String,String> kafkaTemplate;

    @Override
    public IPage<KeyWordsPage> pageByTypeId(KeyWords keyWords, Integer pageNo, Integer pageSize, String keyWordsTypeId, Boolean search, String subjectId, String bindingType) {

        //查询类别id的所有明细id
        List<String> typeIds = new ArrayList<>();
        if (StringUtils.isNotEmpty(keyWordsTypeId) && !"0".equals(keyWordsTypeId)) {
            List<KeywordsType> list = keywordsTypeService.list();
            List<Node> nodeList = new ArrayList<>();
            list.forEach(e->{
                Node node = new Node();
                node.setId(e.getId());
                node.setPid(e.getPid());
                nodeList.add(node);
            });
            typeIds = TreeUtil.belowList(nodeList,keyWordsTypeId,true);
        }
        int searchValue = 0;
        if (Boolean.TRUE.equals(search)) {
           searchValue = 1;
        }
        //查询列表
        Page<KeyWordsPage> page = new Page<>(pageNo, pageSize);

        UserVo loginUser = AuthUtil.getLoginUser();
        String userId = null;
        String customerId = null;
        if(loginUser.getCategory() != null){
            Integer category = loginUser.getCategory();
            if (category.equals(Constants.COMMON_USER)) {
                userId = loginUser.getId();
            } else if (category.equals(Constants.ADMIN_USER)) {
                customerId = loginUser.getRelTenantIds();
            }
        }
        return baseMapper.pageList(userId,customerId,keyWords, typeIds, subjectId, searchValue,bindingType,page);
    }

    @Override
    public JSONObject saveMain(KeyWordsPage keyWordsPage) {
        JSONObject jsonObject = new JSONObject();
        KeyWords keyWords = new KeyWords();
        BeanUtils.copyProperties(keyWordsPage, keyWords);
        String message = "关键词新增成功";
        boolean result = true;
        try {
            //判断关键词合法性
            if (StringUtils.isNotEmpty(keyWords.getKeyWord()) && keyWords.getKeyWord().length() > 500) {
                message = "关键词字段超长，字数限制为500！";
                result = false;
            }
            if (StringUtils.isNotEmpty(keyWords.getExclusionWord()) && keyWords.getExclusionWord().length() > 500) {
                message = "排除词字段超长，字数限制为500！";
                result = false;
            }
            if (result) {
                String wordsCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.KEY_WORDS_DEFAULT.getValue());
                keyWords.setWordsCode(wordsCode);
                //插入关键词表
                baseMapper.insert(keyWords);
                //插入关键词-类别映射关系表
                String keyWordsTypeId = keyWordsPage.getKeyWordsTypeId();
                if (StringUtils.isNotEmpty(keyWordsTypeId)) {
                    addMapMain(keyWords, keyWordsTypeId);
                }
                //插入redis
                KeyWordsDTO keyWordsDTO = new KeyWordsDTO();
                BeanUtils.copyProperties(keyWords, keyWordsDTO);
                redisUtil.set(Constants.KEY_WORDS_TO_REDIS_PREFIX + keyWords.getWordsCode(), keyWordsDTO);
                //插入xxljob
                xxlJobInfoService.keyWordsInsert(keyWordsDTO);
                //为了立即响应，关键词新增时放入一个首次录入消息队列
                kafkaTemplate.send("firstKeyWordsCrawl",JSONObject.toJSONString(keyWords));
            }
            jsonObject.put("result", result);
            jsonObject.put("message", message);
            jsonObject.put("keyWord",keyWords);
            return jsonObject;
        } catch (Exception e) {
            jsonObject.put("result", false);
            jsonObject.put("message", "关键词组新增失败");
            return jsonObject;
        }
    }

    @Override
    public void updateMain(KeyWordsPage keyWordsPage) {
        KeyWords keyWords = new KeyWords();
        BeanUtils.copyProperties(keyWordsPage, keyWords);
        //更细redis缓存
        Object object = redisUtil.get(Constants.KEY_WORDS_TO_REDIS_PREFIX + keyWords.getWordsCode());
        if (object != null) {
            KeyWordsDTO keyWordsDTO = (KeyWordsDTO) object;
            keyWordsDTO.setKeyWord(keyWordsPage.getKeyWord());
            keyWordsDTO.setExclusionWord(keyWordsPage.getExclusionWord());
            redisUtil.set(Constants.KEY_WORDS_TO_REDIS_PREFIX + keyWords.getWordsCode(), keyWordsDTO);
            //判断是否存在，不存在新增
            int count = xxlJobInfoService.selectCount(keyWordsPage.getWordsCode());
            if (count < 1) {
                //之前插入应该异常，再此处再次插入数据
                //插入xxljob
                xxlJobInfoService.keyWordsInsert(keyWordsDTO);
            } else {
                //更新xxljob
                List<String> keyWordsCodes = new ArrayList<>();
                keyWordsCodes.add(keyWordsDTO.getWordsCode());
                xxlJobInfoService.keyWordsUpdate(keyWordsCodes, keyWordsPage.getStatus());
            }
        }
        //插入关键词表
        baseMapper.updateById(keyWords);
        //删除关键词-类别映射关系
        LambdaQueryWrapper<KeywordsTypeMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(KeywordsTypeMap::getKeywordsId,keyWords.getId());
        keywordsTypeMapService.remove(queryWrapper);
        //插入关键词-类别映射关系表
        String keyWordsTypeId = keyWordsPage.getKeyWordsTypeId();
        if (StringUtils.isNotEmpty(keyWordsTypeId)) {
            addMapMain(keyWords, keyWordsTypeId);
        }
        //通知采集更新配置
        //同步配置到采集
        configurationMessageService.sendEditKeyWordsConfigurationMessage(keyWords.getId());

    }

    @Override
    public void deleteMain(String keyWordsId) {
        if (keyWordsId.contains(",")) {
            List<String> idList = Arrays.asList(keyWordsId.split(","));
            for (String wordId : idList) {
                KeyWords keyWords = this.getById(wordId);
                String wordsCode = keyWords.getWordsCode();
                //删除redis缓存
                redisUtil.del(Constants.KEY_WORDS_TO_REDIS_PREFIX + wordsCode);
                //删除xxljob里面的信息
                xxlJobInfoService.deleteByInfosourceCode(wordsCode);
            }
            //删除映射关系
            LambdaQueryWrapper<KeywordsTypeMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(KeywordsTypeMap::getKeywordsId,idList);
            keywordsTypeMapService.remove(queryWrapper);
            this.removeByIds(idList);
        } else {
            KeyWords keyWords = this.getById(keyWordsId);
            String wordsCode = keyWords.getWordsCode();
            //删除redis缓存
            redisUtil.del(Constants.KEY_WORDS_TO_REDIS_PREFIX + wordsCode);
            //删除xxljob里面的信息
            xxlJobInfoService.deleteByInfosourceCode(wordsCode);
            //删除关键词组
            baseMapper.deleteById(keyWordsId);
            //删除映射关系
            LambdaQueryWrapper<KeywordsTypeMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(KeywordsTypeMap::getKeywordsId,keyWords.getId());
            keywordsTypeMapService.remove(queryWrapper);
        }
    }

    @Override
    public KeyWordsPage getKeyWordsById(String keyWordsId) {
        return baseMapper.selectKeyWordsById(keyWordsId);
    }

    @Override
    public KeyWords saveKeyword(Event event, String keyword, String exclusionWord) {
        KeyWords keyWords = new KeyWords();
        if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(exclusionWord)) {
            //关键词
            String wordsCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.KEY_WORDS_DEFAULT.getValue());
            keyWords.setWordsCode(wordsCode);
            keyWords.setWordsName(event.getEventName() + "_" + System.currentTimeMillis());
            keyWords.setKeyWord(keyword);
            keyWords.setExclusionWord(exclusionWord);
            keyWords.setStatus("1");
            this.save(keyWords);
            String keyWordsId = keyWords.getId();
            //关键词和分类关系
            KeywordsTypeMap keywordsTypeMap = new KeywordsTypeMap();
            keywordsTypeMap.setKeywordsId(keyWordsId);
            //分类默认 事件专题
            keywordsTypeMap.setTypeId("1802634369064525826");
            keywordsTypeMapService.save(keywordsTypeMap);
            //专题和关键词关系
            SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
            subjectKeywordsMap.setKeywordsId(keyWordsId);
            subjectKeywordsMap.setSubjectId(event.getId());
            subjectKeywordsMap.setMetaSearchFlag(1);
            subjectKeywordsMapService.save(subjectKeywordsMap);
        }
        return keyWords;
    }

    @Override
    public KeyWords saveKeyword(String subjectId, KeyWords keyWords) {
        if (keyWords != null){
            save(keyWords);
            String keyWordsId = keyWords.getId();
            //专题和关键词关系
            SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
            subjectKeywordsMap.setKeywordsId(keyWordsId);
            subjectKeywordsMap.setSubjectId(subjectId);
            subjectKeywordsMap.setMetaSearchFlag(1);
            subjectKeywordsMapService.save(subjectKeywordsMap);
        }
        return keyWords;
    }

    @Override
    public KeywordsVO keywordInfoByEventId(String eventId) {
        return baseMapper.keywordInfoByEventId(eventId);
    }
    @Override
    public List<KeywordsVO> keywordInfoByEventIdList(String eventId) {
        return baseMapper.keywordInfoByEventIdList(eventId);
    }


    @Override
    public List<KeyWordsPage> bindKeyWordsList(List<String> subjectIds, String groupName, String wordName) {
        return baseMapper.bindKeyWordsList(subjectIds, groupName, wordName);
    }

    @Override
    public Integer bindCount(String subjectId) {
        return baseMapper.bindCount(subjectId);
    }

    @Override
    public List<KeyWordsPage> listByTypeIdList(String userId, String customerId,
                                               List<String> typeIds, String subjectId, int status, String bindingType) {
        return baseMapper.pageListByTypeIdList(userId, customerId,typeIds,subjectId,status,bindingType);
    }

    @Override
    public Integer countByTypeAndIdList(String userId,String customerId,List<String> finalIdList, String subjectId) {
        return baseMapper.countByTypeAndIdList(userId,customerId,finalIdList,subjectId);
    }

    private void addMapMain(KeyWords keyWords, String keyWordsTypeId) {
        KeywordsTypeMap keywordsTypeMap = new KeywordsTypeMap();
        keywordsTypeMap.setKeywordsId(keyWords.getId());
        keywordsTypeMap.setTypeId(keyWordsTypeId);
        keywordsTypeMap.setUpdateBy(keyWords.getUpdateBy());
        keywordsTypeMap.setUpdateTime(keyWords.getUpdateTime());
        keywordsTypeMap.setSysOrgCode(keyWords.getSysOrgCode());
        keywordsTypeMapService.save(keywordsTypeMap);
    }
    @Override
    public List<KeyWordsPage> bindKeyWordsListByIdsAndBindType(List<String> ids, String bindingType,Integer metaSearchFlag) {
        return baseMapper.bindKeyWordsListByIdsAndBindType(ids,bindingType,metaSearchFlag);
    }

    @Override
    @Transactional
    public void saveBaseAndMap(Event event, String keyword, String exclusionWord) {
        if (StringUtils.isNotEmpty(keyword)) {
            addMapMain(event, keyword,1);
        }
        if (StringUtils.isNotEmpty(exclusionWord)) {
            addMapMain(event, exclusionWord,2);
        }
    }

    @Override
    @Transactional
    public void updateBaseAndMap(Event event, String keyword, String exclusionWord) {
        //采集词
        LambdaQueryWrapper<SubjectKeywordsMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectKeywordsMap::getSubjectId, event.getId()).eq(SubjectKeywordsMap::getBindingType, 1);
        SubjectKeywordsMap one = subjectKeywordsMapService.getOne(queryWrapper);
        if (one != null) {
            String keywordsId = one.getKeywordsId();
            LambdaUpdateWrapper<KeyWords> update = Wrappers.lambdaUpdate();
            update.set(KeyWords::getKeyWord, keyword).eq(KeyWords::getId, keywordsId);
            this.update(update);
        }
        //排除词
        LambdaQueryWrapper<SubjectKeywordsMap> query = Wrappers.lambdaQuery();
        query.eq(SubjectKeywordsMap::getSubjectId, event.getId()).eq(SubjectKeywordsMap::getBindingType, 3);
        SubjectKeywordsMap excludeOne = subjectKeywordsMapService.getOne(queryWrapper);
        if (StringUtils.isNotEmpty(exclusionWord)) {
            if (excludeOne == null) {
                addMapMain(event, exclusionWord,2);
            } else {
                String keywordsId = excludeOne.getKeywordsId();
                LambdaUpdateWrapper<KeyWords> update = Wrappers.lambdaUpdate();
                update.set(KeyWords::getKeyWord, exclusionWord).eq(KeyWords::getId, keywordsId);
                this.update(update);
            }
        } else {
            if (excludeOne != null) {
                this.removeById(excludeOne.getKeywordsId());
                subjectKeywordsMapService.removeById(excludeOne.getId());
                LambdaQueryWrapper<SubjectKeywordsGroupRelation> wrapper = Wrappers.lambdaQuery();
                wrapper.eq(SubjectKeywordsGroupRelation::getRelationType, 3)
                        .eq(SubjectKeywordsGroupRelation::getSubjectId, excludeOne.getSubjectId());
                subjectKeywordsGroupRelationService.remove(wrapper);
            }
        }
    }

    @Override
    @Transactional
    public void removeBaseAndMap(String eventId) {
        LambdaQueryWrapper<SubjectKeywordsMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectKeywordsMap::getSubjectId, eventId);
        List<SubjectKeywordsMap> list = subjectKeywordsMapService.list(queryWrapper);
        Set<String> ids = list.stream().map(SubjectKeywordsMap::getKeywordsId).collect(Collectors.toSet());
        this.removeByIds(ids);
        subjectKeywordsMapService.remove(queryWrapper);
        LambdaQueryWrapper<SubjectKeywordsGroupRelation> query = Wrappers.lambdaQuery();
        query.eq(SubjectKeywordsGroupRelation::getSubjectId, eventId);
        subjectKeywordsGroupRelationService.remove(query);
    }

    private void addMapMain(Event event, String keyword, Integer type) {
        KeyWords keyWords = new KeyWords();
        //关键词
        String wordsCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.KEY_WORDS_DEFAULT.getValue());
        keyWords.setWordsCode(wordsCode);
        String wordsName = event.getEventName() + "_" + System.currentTimeMillis();
        keyWords.setWordsName(wordsName);
        keyWords.setKeyWord(keyword);
        keyWords.setStatus("1");
        this.save(keyWords);
        String keyWordsId = keyWords.getId();
        //关键词和分类关系
        KeywordsTypeMap keywordsTypeMap = new KeywordsTypeMap();
        keywordsTypeMap.setKeywordsId(keyWordsId);
        //分类默认 事件专题
        keywordsTypeMap.setTypeId("1802634369064525826");
        keywordsTypeMapService.save(keywordsTypeMap);
        //词组间关系
        List<SubjectKeywordsGroupRelation> relationList = new ArrayList<>();
        //专题和关键词关系
        List<SubjectKeywordsMap> dataList = new ArrayList<>();
        if (type == 1) {
            for (int i = 1; i < 3; i++) {
                //专题和词组关系
                SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
                subjectKeywordsMap.setKeywordsId(keyWordsId);
                subjectKeywordsMap.setSubjectId(event.getId());
                subjectKeywordsMap.setType("1");
                subjectKeywordsMap.setBindingType(String.valueOf(i));
                subjectKeywordsMap.setMetaSearchFlag(1);
                dataList.add(subjectKeywordsMap);
                //词组关系
                SubjectKeywordsGroupRelation relation = new SubjectKeywordsGroupRelation();
                relation.setSubjectId(event.getId());
                relation.setKeywordsGroupIds(keyWordsId);
                relation.setRelationType(String.valueOf(i));
                relation.setExpressionStr(keyWordsId);
                JSONArray jsonArray = new JSONArray();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("title", wordsName);
                jsonObject.put("value", keyWordsId);
                jsonArray.add(jsonObject);
                relation.setParamsStr(JSON.toJSONString(jsonArray));
                relationList.add(relation);
            }
        } else if (type == 2) {
            //专题和词组关系
            SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
            subjectKeywordsMap.setKeywordsId(keyWordsId);
            subjectKeywordsMap.setSubjectId(event.getId());
            subjectKeywordsMap.setType("1");
            subjectKeywordsMap.setBindingType("3");
            dataList.add(subjectKeywordsMap);
            //词组关系
            SubjectKeywordsGroupRelation relation = new SubjectKeywordsGroupRelation();
            relation.setSubjectId(event.getId());
            relation.setKeywordsGroupIds(keyWordsId);
            relation.setRelationType("3");
            relation.setExpressionStr(keyWordsId);
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("title", wordsName);
            jsonObject.put("value", keyWordsId);
            jsonArray.add(jsonObject);
            relation.setParamsStr(JSON.toJSONString(jsonArray));
            relationList.add(relation);
        }
        subjectKeywordsMapService.saveBatch(dataList);
        subjectKeywordsGroupRelationService.saveBatch(relationList);
    }
}
