package com.zzsn.event.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * python工具类
 *
 * @author lkg
 * @date 2025/1/23
 */
@Service
public class PythonUtil {

    @Value("${python.keyWordsExtractUrl}")
    private String keywordExtractUrl;

    /**
     * 提取关键词
     *
     * @param content 文本内容
     * @param number  提取的关键词数量
     * @author lkg
     * @date 2025/1/23
     */
    public List<String> extractKeyword(String content, Integer number) {
        List<String> wordsList = new ArrayList<>();
        if (StringUtils.isNotBlank(content)) {
            Map<String, Object> params = new HashMap<>();
            params.put("text", content);
            params.put("name", "phrase");
            params.put("topK", number.toString());
            String result = HttpUtil.doPostForm(keywordExtractUrl, params, 60000);
            JSONObject jsonObject = JSONObject.parseObject(result);
            JSONObject resultData = jsonObject.getJSONObject("resultData");
            if (resultData != null) {
                JSONArray data = resultData.getJSONArray("data");
                wordsList = JSON.parseArray(data.toString(), String.class);
            }
        }
        return wordsList;
    }
}
