package com.zzsn.event.util;

public final class TenantHelper implements AutoCloseable {
    // test or pro
    private static final ThreadLocal<String> CONTEXT = new ThreadLocal();
    private static final TenantHelper HELPER = new TenantHelper();
    private TenantHelper() {
    }

    public static TenantHelper getInstance() {
        return HELPER;
    }

    @Override
    public void close() throws Exception {
        CONTEXT.remove();
    }
    public String getTenant() {
        return (String)CONTEXT.get();
    }

    public static void setTenant(String tenant) {
        CONTEXT.set(tenant);
    }

}
