package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectDictMap;
import com.zzsn.event.service.SubjectDictMapService;
import com.zzsn.event.mapper.SubjectDictMapMapper;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.DictVO;
import com.zzsn.event.vo.SubjectBindLabelParam;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
* @author lenovo
* @description 针对表【subject_dict_map(专题-字典关系表)】的数据库操作Service实现
* @createDate 2025-03-28 11:56:32
*/
@Service
public class SubjectDictMapServiceImpl extends ServiceImpl<SubjectDictMapMapper, SubjectDictMap> implements SubjectDictMapService{

    @Override
    public void modify(SubjectBindLabelParam bindLabelParam) {
        String subjectId = bindLabelParam.getSubjectId();
        List<String> dictIdList = bindLabelParam.getDictIdList();
        LambdaQueryWrapper<SubjectDictMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectDictMap::getSubjectId,subjectId);
        int count = this.count(queryWrapper);
        if (count > 0) {
            this.remove(queryWrapper);
        }
        List<SubjectDictMap> subjectDictMaps = new ArrayList<>();
        for (String dictId : dictIdList) {
            SubjectDictMap subjectDictMap = new SubjectDictMap();
            subjectDictMap.setSubjectId(subjectId);
            subjectDictMap.setDictId(dictId);
            subjectDictMaps.add(subjectDictMap);
        }
        this.saveBatch(subjectDictMaps);
    }

    @Override
    public List<DictVO> boundList(String subjectId) {
        return baseMapper.boundList(subjectId);
    }
}




