package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.entity.arrange.ClbModelArrange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@ApiModel(value="SubjectPage", description="专题列表页面")
public class SubjectPage {

    private String id;
    /**项目编码*/
    @Excel(name = "专题编码", width = 15)
    @ApiModelProperty(value = "专题编码")
    private String subjectCode;
    /**专题名称*/
    @Excel(name = "专题名称", width = 15)
    @ApiModelProperty(value = "专题名称")
    private String subjectName;

    /**绑定的类别*/
    @Excel(name = "类别", width = 15)
    @ApiModelProperty(value = "类别")
    private String subjectTypeId;

    private String subjectTypeName;

    /**项目id*/
    @Excel(name = "项目id", width = 15)
    @ApiModelProperty(value = "项目id")
    private String projectId;

    private String projectName;

    /**父级节点*/
    @Excel(name = "父级节点", width = 15)
    @ApiModelProperty(value = "父级节点")
    private String pid;
    /**状态*/
    @Excel(name = "状态", width = 15, dicCode = "clb_subject_status")
    @ApiModelProperty(value = "状态")
    private Integer status = 0;
    /**是否公开(0-未公开;1-已公开)*/
    private Integer facePublic;
    /**数据来源(0-平台数据;1-全网搜)*/
    private Integer dataSource;
    /**启用时间*/
    @Excel(name = "启用时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "启用时间")
    private Date timeEnable;
    /**停用时间*/
    @Excel(name = "停用时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "停用时间")
    private Date timeDisable;
    /**划分专题库*/
    @Excel(name = "划分专题库", width = 15, dicCode = "Thematic_Library")
    @ApiModelProperty(value = "划分专题库")
    private String library;
    /**定时单位(1分；2小时；3日；4月)*/
    @ApiModelProperty(value = "定时单位")
    private String unit;
    /**定时数值*/
    @ApiModelProperty(value = "定时数值")
    private Integer space;
    /**cron表达式*/
    @ApiModelProperty(value = "cron表达式")
    private String cron;
    /**是否提取热词*/
    @ApiModelProperty(value = "是否提取热词")
    private String ynExtractHotWords;
    /**版本号*/
    @Excel(name = "版本号", width = 15)
    @ApiModelProperty(value = "版本号")
    private Integer version;
    /**是否有子节点*/
    @Excel(name = "是否有子节点", width = 15, dicCode = "yn")
    @ApiModelProperty(value = "是否有子节点")
    private String hasChild;
    /**所属客户*/
    private String customerId;
    /**专题信息所在es库名称*/
    private String esIndex;
    /**排序号*/
    private Integer sortOrder;
    /**备注
     */
    private String remark;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
    /**专题类型(1-普通专题;3-嵌套专题)*/
    private Integer subjectType;

    /**信息源数量*/
    private Integer infoSourceNum;
    /**关键词数量*/
    private Integer keyWordsNum;


    /**绑定的信息源组list*/
    private  List<String> infoSourceIds;
    /**排除的信息源组list*/
    private  List<String> excludeInfoSourceIds;
    /**定向组list*/
    private  List<String> directionIds;


    /**关键词组list*/
    @ApiModelProperty(value = "关键词组id list")
    private  List<String> keyWordsIds;
    @ApiModelProperty(value = "关键词绑定类型")
    private String bindingType;
    /**搜索引擎list*/
    @ApiModelProperty(value = "搜索引擎list")
    private  List<String> searchEngineIds;
    /**是否全部信息源*/
    @ApiModelProperty(value = "是否全部信息源")
    private  Boolean ynAll;
    /**绑定的模型ids*/
    @ApiModelProperty(value = "绑定的模型ids")
    private  List<String> modelIds;
    /**绑定的模型ids*/
    @ApiModelProperty(value = "绑定的模型ids")
    private  List<PythonModelVo> models;
    /**绑定的模型种类（1：去重模型  2：筛选模型  3：标签模型）*/
    @ApiModelProperty(value = "绑定的模型种类（1：去重模型  2：筛选模型  3：标签模型）")
    private  String type;

    /**任务code*/
    private String taskCode;
    /**分类(1-专题;2-事件)*/
    private Integer category;
    /**预估状态*/
    private String estimateStatus;
    /**是否审核*/
    private String enterpriseCheck;
    /**数据类型*/
    private String additionDataType;
    /**
     * 信息源绑定-新
     * */
    //id（可以是信息源组id集合，可以是信息源id集合）
    private List<String> bindIds;
    //信息源标签
    private List<BindLabelVo> bindLabels;
    //绑定类型类型（1：通用  2：定向  3:屏蔽）
    private String sourceBindType;
    //信息源类型（1：信息源组  2：信息源  3:标签）
    private String sourceType;
    /**
     * 信息源绑定-新end
     * */


    private List<ClbModelArrange> clbModelArranges;
    /** 环境 1-测试 2-正式 */
    private String environment;
    /**是否处理无发布时间的资讯：1是，0否--默认为0*/
    private Integer noPublishTimeFlag=0;

    /**信息总数量*/
    private Integer totalNum;
    /**待审核数量*/
    private Integer unCheckNum;
    /**绑定信息源数量*/
    private Integer bindSourceNum;
    /**绑定关键词组数量*/
    private Integer bindKeywordNum;
    /**最新数据日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date latestDataDate;
}
