package com.zzsn.event.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.EnumHandlerStatus;
import com.zzsn.event.enums.EnumOperateWay;
import com.zzsn.event.es.EsService;
import com.zzsn.event.mapper.SubjectMapper;
import com.zzsn.event.service.*;
import com.zzsn.event.util.*;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.*;
import com.zzsn.event.vo.es.*;
import com.zzsn.event.vo.log.DataLifecycleLog;
import com.zzsn.event.entity.InfoSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.jsoup.Jsoup;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * 资讯
 *
 * @author lkg
 * @date 2024/12/19
 */
@Slf4j
@Service
public class InformationServiceImpl implements InformationService {

    @Autowired
    private EsService esService;
    @Autowired
    private EsOpUtil esOpUtil;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private IEventService eventService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private ISubjectTypeService subjectTypeService;
    @Autowired
    private ISubjectTypeMapService subjectTypeMapService;
    @Autowired
    private ISubjectInfoSourceMapService subjectInfoSourceMapService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private IInfoSourceService infoSourceService;
    @Autowired
    private IKeyWordsService keyWordsService;
    @Autowired
    private IClbSysAttachmentService clbSysAttachmentService;
    @Autowired
    private IClbFileOperationLogService clbFileOperationLogService;
    @Autowired
    private IClbFileOperationLogDetailsService clbFileOperationLogDetailsService;
    @Autowired
    private ICollectionMapService collectionMapService;
    @Autowired
    private SysDictItemService sysDictItemService;
    @Autowired
    private PythonUtil pythonUtil;
    @Autowired
    private ImageUtil imageUtil;
    private String subjectId = "1898653164373065730";//中外智库专栏对应专题id

    @Override
    public IPage<EventDataVO> collectPageList(InfoDataSearchCondition eventDataCondition) {
        return esService.collectPageList(eventDataCondition);
    }

    @Override
    public IPage<DisplayInfo> subjectPageList(InfoDataSearchCondition searchCondition) {
        IPage<DisplayInfo> page = new Page<>(searchCondition.getPageNo(), searchCondition.getPageSize());
        Integer category = searchCondition.getCategory();
        List<String> subjectIdList = new ArrayList<>();
        //判断是否是专题
        if ("1".equals(searchCondition.getIsSubject())) {
            if (StringUtils.isNotEmpty(searchCondition.getSubjectId())) {
                subjectIdList.add(searchCondition.getSubjectId());
            }
        } else {
            //该id其实是专题类别id
            //查询类别id的所有明细id
            String subjectTypeId = searchCondition.getSubjectId();
            List<String> typeIds = subjectTypeService.belowIdList(subjectTypeId, category);
            if (category == 1) {
                subjectIdList = subjectTypeMapService.selectSubjectByTypeIds(typeIds);
            } else if (category == 2) {
                subjectIdList = subjectTypeMapService.selectEventByTypeIds(typeIds);
            }
        }
        if (CollectionUtils.isEmpty(subjectIdList)) {
            return page;
        }
        String reportId = searchCondition.getReportId();
        if (StringUtils.isNotEmpty(reportId)) {
            ReportConditionVO reportCondition = commonService.getReportCondition(reportId);
            String dataBaseCondition = reportCondition.getDataBaseCondition();
            if (StringUtils.isEmpty(dataBaseCondition)) {
                dataBaseCondition = "{}";
            }
            JSONObject reportBaseCondition = JSONObject.parseObject(dataBaseCondition);
            reportBaseCondition.put("startTime", reportCondition.getStartTime());
            reportBaseCondition.put("endTime", reportCondition.getEndTime());
            JSONObject searchConditionJsonObject = ObjectUtil.objectToJSONObject(searchCondition);
            reportBaseCondition.forEach((key, value) -> {
                if (!searchConditionJsonObject.containsKey(key)) {
                    searchConditionJsonObject.put(key, value);
                }
            });
            searchCondition = JSONObject.parseObject(JSONObject.toJSONString(searchConditionJsonObject), InfoDataSearchCondition.class);
        }
        try {
            IPage<SpecialInformation> specialInformationIPage = esService.pageListByCondition(searchCondition, subjectIdList);
            long total = specialInformationIPage.getTotal();
            if (total > 0) {
                List<DisplayInfo> dataList = new ArrayList<>();
                List<LabelModelVo> labelModelVos = commonService.subjectModelBindLabels(subjectIdList);
                Map<String, List<LabelModelVo>> modelMap = labelModelVos.stream().collect(Collectors.groupingBy(LabelModelVo::getSubjectId));
                List<SpecialInformation> records = specialInformationIPage.getRecords();
                for (SpecialInformation specialInformation : records) {
                    DisplayInfo info = new DisplayInfo();
                    BeanUtils.copyProperties(specialInformation, info);
                    String publishDate = info.getPublishDate();
                    if (StringUtils.isNotEmpty(publishDate) && publishDate.length() > 10) {
                        publishDate = EsDateUtil.esFieldDateMapping(info.getPublishDate());
                        String dateFormat = searchCondition.getDateFormat();
                        if (!dateFormat.equals("yyyy-MM-dd HH:mm:ss")) {
                            info.setPublishDate(DateUtil.formatStr(publishDate,"yyyy-MM-dd HH:mm:ss", dateFormat));
                        }
                    }
                    //标签处理
                    List<LabelModelVo> modelVoList = modelMap.get(info.getSubjectId());
                    formatLabel(modelVoList, info);
                    dataList.add(info);
                }
                page.setRecords(dataList);
                page.setTotal(total);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return page;
    }

    @Override
    public IPage<SpecialInformation> subjectPageListForDataDetail(InfoDataSearchCondition searchCondition) {
        IPage<SpecialInformation> page = new Page<>(searchCondition.getPageNo(), searchCondition.getPageSize());
        Integer category = searchCondition.getCategory();
        List<String> subjectIdList = new ArrayList<>();
        //判断是否是专题
        if ("1".equals(searchCondition.getIsSubject())) {
            if (StringUtils.isNotEmpty(searchCondition.getSubjectId())) {
                subjectIdList.add(searchCondition.getSubjectId());
            }
        } else {
            //该id其实是专题类别id
            //查询类别id的所有明细id
            String subjectTypeId = searchCondition.getSubjectId();
            List<String> typeIds = subjectTypeService.belowIdList(subjectTypeId, category);
            if (category == 1) {
                subjectIdList = subjectTypeMapService.selectSubjectByTypeIds(typeIds);
            } else if (category == 2) {
                subjectIdList = subjectTypeMapService.selectEventByTypeIds(typeIds);
            }
        }
        if (CollectionUtils.isEmpty(subjectIdList)) {
            return page;
        }
        try {
            return esService.pageListByCondition(searchCondition, subjectIdList);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return page;
    }

    @Autowired
    private SubjectMapper subjectMapper;


    @Override
    public Result subjectPageListGroupByLabel(UserVo userVo, InfoDataSearchCondition searchCondition) {
        List<HashMap> list = new ArrayList<>();
        Integer category = searchCondition.getCategory();
        List<String> subjectIdList = new ArrayList<>();
        //判断是否是专题
        if ("1".equals(searchCondition.getIsSubject())) {
            if (StringUtils.isNotEmpty(searchCondition.getSubjectId())) {
                subjectIdList.add(searchCondition.getSubjectId());
            }
        } else {
            //该id其实是专题类别id
            //查询类别id的所有明细id
            String subjectTypeId = searchCondition.getSubjectId();
            List<String> typeIds = subjectTypeService.belowIdList(subjectTypeId, category);
            if (category == 1) {
                subjectIdList = subjectTypeMapService.selectSubjectByTypeIds(typeIds);
            } else if (category == 2) {
                subjectIdList = subjectTypeMapService.selectEventByTypeIds(typeIds);
            }
        }
        if (CollectionUtils.isEmpty(subjectIdList)) {
            return Result.OK(list);
        }
        try {
            IPage<SpecialInformation> specialInformationIPage = esService.pageListByCondition(searchCondition, subjectIdList);
            long total = specialInformationIPage.getTotal();
            if (total > 0) {
                List<DisplayInfo> dataList = new ArrayList<>();
                List<LabelModelVo> labelModelVos = commonService.subjectModelBindLabels(subjectIdList);
                Map<String, List<LabelModelVo>> modelMap = labelModelVos.stream().collect(Collectors.groupingBy(LabelModelVo::getSubjectId));
                List<SpecialInformation> records = specialInformationIPage.getRecords();
                for (SpecialInformation specialInformation : records) {
                    DisplayInfo info = new DisplayInfo();
                    BeanUtils.copyProperties(specialInformation, info);
                    info.setPublishDate(EsDateUtil.esFieldDateYmd(info.getPublishDate()));
                    //标签处理
                    List<LabelModelVo> modelVoList = modelMap.get(info.getSubjectId());
                    formatLabel(modelVoList, info);

                    try {
                        //多个主题的保留分数最高的
                        List<Label> listLabel = info.getLabels();
                        // 使用流操作找到score最大的Label
                        Optional<Label> maxLabel = listLabel.stream()
                                .filter(label -> searchCondition.getLabelMark().equals(label.getLabelMark())) // 过滤labelMark
                                .peek(label -> label.setStatus(label.getStatus() == null ? 0 : label.getStatus())) // 将null赋值为0
                                .max(Comparator.comparingDouble(Label::getStatus));
                        List<Label> maxLabelList = maxLabel.map(Collections::singletonList).orElse(Collections.emptyList());
                        info.setLabels(maxLabelList);
                    } catch (Exception e) {
                        log.error("处理得分最高标签异常", e);
                    }
                    dataList.add(info);
                }
                Map<String, List<DisplayInfo>> mapList = groupedByLabelMark(dataList, searchCondition);
                mapList.forEach((relationName, displayInfos) -> {
                    List<DisplayInfo> listN = new ArrayList<>();
                    Integer num = 0;
                    for (DisplayInfo obj : displayInfos) {
                        DisplayInfo copy = new DisplayInfo();
                        BeanUtils.copyProperties(obj, copy);
                        num++;
                        copy.setIndex(num + ".");
//                        copy.setTitle(StringUtils.isNotEmpty(copy.getTitle())?copy.getTitle() + "。":"");
                        listN.add(copy);
                    }
                    HashMap map = new HashMap();
                    map.put("relationName", relationName);
                    map.put("infoList", listN);
                    list.add(map);
                });
            } else {
                //不加标签获取列表数据
                searchCondition.setLabelMark(null);
                //中外智库专栏-数据需排序
                if (StringUtils.isNotBlank(searchCondition.getSubjectId()) && searchCondition.getSubjectId().equals(subjectId)) {
                    searchCondition.setColumn("yqgzzk");
                }
                specialInformationIPage = esService.pageListByCondition(searchCondition, subjectIdList);
                long totalT = specialInformationIPage.getTotal();
                if (totalT > 0) {
                    List<DisplayInfo> dataList = new ArrayList<>();
                    List<LabelModelVo> labelModelVos = commonService.subjectModelBindLabels(subjectIdList);
                    Map<String, List<LabelModelVo>> modelMap = labelModelVos.stream().collect(Collectors.groupingBy(LabelModelVo::getSubjectId));
                    List<SpecialInformation> records = specialInformationIPage.getRecords();
                    Integer num = 0;
                    for (SpecialInformation specialInformation : records) {
                        num++;
                        DisplayInfo info = new DisplayInfo();
                        BeanUtils.copyProperties(specialInformation, info);
                        info.setPublishDate(EsDateUtil.esFieldDateYmd(info.getPublishDate()));
                        //标签处理
                        List<LabelModelVo> modelVoList = modelMap.get(info.getSubjectId());
                        formatLabel(modelVoList, info);
                        info.setIndex(num + ".");
//                        info.setTitle(StringUtils.isNotEmpty(info.getTitle())?info.getTitle() + "。":"");
                        dataList.add(info);
                    }
                    //中外智库专栏-数据需过滤
                    if (StringUtils.isNotBlank(searchCondition.getSubjectId()) && searchCondition.getSubjectId().equals(subjectId)) {
                        ArrayList<DisplayInfo> saveList = new ArrayList<>(list.size());
                        List<String> titles = new ArrayList<>(list.size());
                        for (DisplayInfo s : dataList) {
                            String title = s.getTitle().trim();
                            int tem = 0;
                            for (String t : titles) {
                                double simforcatl = SimilarityUtil.simforcatl(title, t);
                                if (simforcatl > 0.83) {
                                    log.info("getArticleNode 获取文章列表中标题为[{}],和标题为[{}],的相似度大于80%过滤后者", title, t);
                                    tem = 1;
                                    break;
                                }
                            }
                            if (tem == 0) {
                                titles.add(title);
                            } else {
                                continue;
                            }
                            saveList.add(s);
                        }
                        for (DisplayInfo info : saveList) {
                            if (StringUtils.isNotBlank(info.getSubtitle())) {
                                info.setTitle(info.getSubtitle() + info.getTitle());
                            }
                        }
                        return Result.OK(saveList);
                    }
                    return Result.OK(dataList);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Result.OK(list);
    }

    public Map<String, List<DisplayInfo>> groupedByLabelMark(List<DisplayInfo> dataList, InfoDataSearchCondition searchCondition) {
        // 使用 Stream API 对 dataList 进行分组
        Map<String, List<DisplayInfo>> groupedByLabelMark = dataList.stream()
                // 将每个 DisplayInfo 对象映射到一个或多个 labelMark
                .flatMap(displayInfo -> displayInfo.getLabels().stream()
                        // 映射每个 Label 到其 labelMark
                        .filter(label -> label.getRelationName() != null)
                        .filter(label -> Optional.ofNullable(searchCondition.getLabelMark())
                                // 如果 searchCondition.getLabelMark() 非空，则应用过滤条件
                                .map(labelMark -> labelMark.equals(label.getLabelMark()))
                                // 如果 searchCondition.getLabelMark() 为空，则默认为 true（不应用过滤条件）
                                .orElse(true))
                        .map(label -> new AbstractMap.SimpleEntry<>(label.getRelationName(), displayInfo)))
                // 根据 labelMark 进行分组
                .collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey,
                        // 将分组后的 DisplayInfo 对象收集到列表中
                        Collectors.mapping(AbstractMap.SimpleEntry::getValue, Collectors.toList())));
        return groupedByLabelMark;
    }

    @Override
    public DisplayInfo queryInfo(Integer type, String index, String id) {
        DisplayInfo info = (DisplayInfo) esOpUtil.getInfoById(index, id, DisplayInfo.class);
        info.setDbIndex(index);
        if (StringUtils.isNotEmpty(info.getContentWithTag())) {
            String contentNoTag = Utility.TransferHTML2TextWithImg(info.getContentWithTag());
            String contentNoTag2 = Utility.dealImg(contentNoTag);
            info.setContent(contentNoTag2);
        }
        info.setPublishDate(EsDateUtil.esFieldDateMapping(info.getPublishDate()));
        if (null != type && type == 2) {
            //获取附件信息
            if (info.getAttachmentIds() != null && info.getAttachmentIds().size() > 0) {
                List<AttachmentInfo> attachmentInfoList = new ArrayList<>();
                for (String attachmentId : info.getAttachmentIds()) {
                    QueryWrapper<ClbSysAttachment> queryWrapper = Wrappers.query();
                    queryWrapper.eq("id", attachmentId);
                    ClbSysAttachment clbSysAttachment = clbSysAttachmentService.getOne(queryWrapper);
                    if (clbSysAttachment != null) {
                        AttachmentInfo attachmentInfo = new AttachmentInfo();
                        attachmentInfo.setAttachmentName(clbSysAttachment.getName());
                        attachmentInfo.setAttachmentPath(clbSysAttachment.getPath());
                        attachmentInfo.setGroup(clbSysAttachment.getGroupName());
                        attachmentInfo.setAttachmentId(String.valueOf(clbSysAttachment.getId()));
                        attachmentInfo.setAttachmentFullPath(Constants.OBS_FILE_PATH_URL_PREFIX + clbSysAttachment.getObjectKey());
                        attachmentInfo.setPageSize(clbSysAttachment.getPageSize());
                        attachmentInfo.setSource(clbSysAttachment.getSource());
                        attachmentInfo.setFileSize(clbSysAttachment.getFileSize());
                        attachmentInfoList.add(attachmentInfo);
                    }
                }
                info.setAttachmentInfos(attachmentInfoList);
                info.setYnArticle(false);
            }
        }
        CompletableFuture.runAsync(() -> addReadNum(info, index));
        return info;
    }

    @Override
    public void saveAsDataSet(InfoDataSearchCondition searchCondition) {
        String[] fetchFields = new String[]{"id", "labels"};
        searchCondition.setFetchFields(fetchFields);
        Label dataSet = new Label();
        String dataSetId = searchCondition.getDataSetId();
        dataSet.setRelationId(dataSetId);
        Map<String, List<SpecialInformation>> map = new HashMap<>();
        List<SpecialInformation> informationList = this.informationAllList(searchCondition);
        formatUpdateMap(map, informationList, dataSet);
        map.forEach((k, v) -> esOpUtil.docUpdateBulk(k, v));
    }

    @Override
    public void removeLabels(InfoDataSearchCondition searchCondition) {
        String[] fetchFields = new String[]{"id", "labels"};
        searchCondition.setFetchFields(fetchFields);
        List<Label> removeLabels = new ArrayList<>();
        String removeRelationId = searchCondition.getRemoveRelationId();
        for (String relationId : removeRelationId.split(",")) {
            Label dataSet = new Label();
            dataSet.setRelationId(relationId);
            removeLabels.add(dataSet);
        }
        Map<String, List<SpecialInformation>> map = new HashMap<>();
        List<SpecialInformation> informationList = this.informationAllList(searchCondition);
        formatUpdateMap(map, informationList, removeLabels);
        map.forEach((k, v) -> esOpUtil.docUpdateBulk(k, v));
    }

    /**
     * 格式化数据
     *
     * @param map             待更新的数据map集合
     * @param informationList 查询到的数据集合
     * @param dataSet         数据集标签信息
     * @author lkg
     * @date 2025/2/28
     */
    private void formatUpdateMap(Map<String, List<SpecialInformation>> map, List<SpecialInformation> informationList, Label dataSet) {
        for (SpecialInformation information : informationList) {
            String index = information.getDbIndex();
            List<Label> labels = information.getLabels();
            if (CollectionUtils.isNotEmpty(labels)) {
                boolean present = labels.stream().anyMatch(label -> label.getRelationId().equals(dataSet.getRelationId()));
                if (!present) {
                    labels.add(dataSet);
                }
            } else {
                labels = new ArrayList<>();
                labels.add(dataSet);
            }
            information.setLabels(labels);
            information.setUpdateDate(EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
            if (map.containsKey(index)) {
                map.get(index).add(information);
            } else {
                List<SpecialInformation> list = new ArrayList<>();
                list.add(information);
                map.put(index, list);
            }
        }
    }

    private void formatUpdateMap(Map<String, List<SpecialInformation>> map, List<SpecialInformation> informationList, List<Label> removeLabels) {
        for (SpecialInformation information : informationList) {
            String index = information.getDbIndex();
            List<Label> newLabels = new ArrayList<>();
            List<Label> labels = information.getLabels();
            if (CollectionUtils.isNotEmpty(labels)) {
                for (Label label : labels) {
                    boolean present = removeLabels.stream().anyMatch(e -> e.getRelationId().equals(label.getRelationId()));
                    if (!present) {
                        newLabels.add(label);
                    }
                }
            }
            information.setLabels(newLabels);
            information.setUpdateDate(EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
            if (map.containsKey(index)) {
                map.get(index).add(information);
            } else {
                List<SpecialInformation> list = new ArrayList<>();
                list.add(information);
                map.put(index, list);
            }
        }
    }

    @Override
    public List<List<String>> statisticsExportList(String subjectId, String startDate, String endDate) {
        List<String> subjectIdList = new ArrayList<>();
        //查询类别id的所有明细id
        if (!"0".equals(subjectId)) {
            List<String> typeIds = subjectTypeService.belowIdList(subjectId, 1);
            subjectIdList = subjectTypeMapService.selectSubjectByTypeIds(typeIds);
        }
        subjectIdList.add(subjectId);
        //专题关联的信息源集合
        List<SubjectStatisticsVo> infoSourceList = subjectInfoSourceMapService.subjectRealBindInfoSources(subjectIdList);
        List<String> dateList = DateUtil.betweenDate(startDate, endDate);
        List<List<String>> dataList = new ArrayList<>();
        Map<String, Map<String, Long>> stringMapMap = esService.regetFromEs(infoSourceList.stream().map(SubjectStatisticsVo::getId).collect(Collectors.toList()), startDate, endDate);
        //封装导出excel需要的数据集合
        for (SubjectStatisticsVo subjectStatisticsVo : infoSourceList) {
            Map<String, Long> stringLongMap = stringMapMap.get(subjectStatisticsVo.getId());
            List<SubjectStatisticsVo> value = new ArrayList<>();
            int sum = 0;
            if (null != stringLongMap) {
                for (Map.Entry<String, Long> entry : stringLongMap.entrySet()) {
                    String date = entry.getKey();
                    Long count = entry.getValue();
                    SubjectStatisticsVo subjectStatisticsVoTemp = new SubjectStatisticsVo();
                    subjectStatisticsVoTemp.setId(subjectStatisticsVo.getId());
                    subjectStatisticsVoTemp.setSiteName(subjectStatisticsVo.getSiteName());
                    subjectStatisticsVoTemp.setDate(date);
                    int num = Math.toIntExact(count);
                    subjectStatisticsVoTemp.setCollectCount(num);
                    value.add(subjectStatisticsVoTemp);
                    sum += Math.toIntExact(count);
                }
            }
            List<String> list = subjectStatisticsVo.toExcelList();
            //信息源在时间段内的采集总量
            list.add(String.valueOf(sum));
            //信息源采集到数据的日期集合
            Set<String> collectDates = value.stream().collect(Collectors.groupingBy(SubjectStatisticsVo::getDate)).keySet();
            //信息源未采集到数据的日期集合
            List<String> noCollectDates = new ArrayList<>(dateList);
            noCollectDates.removeAll(collectDates);
            for (String date : noCollectDates) {
                SubjectStatisticsVo vo = new SubjectStatisticsVo();
                BeanUtils.copyProperties(subjectStatisticsVo, vo);
                vo.setCollectCount(0);
                vo.setDate(date);
                value.add(vo);
            }
            //根据采集时间排序(正序)
            value.sort(Comparator.comparing(SubjectStatisticsVo::getDate));
            value.forEach(e -> list.add(String.valueOf(e.getCollectCount())));
            dataList.add(list);
        }
        return dataList;
    }

    @Override
    public void manualAdd(List<ManualAddVO> manualAddVOs) {
        for (ManualAddVO manualAddVO : manualAddVOs) {
            try {
                String id = manualAddVO.getId();
                String subjectId = manualAddVO.getSubjectId();
                String subjectName = manualAddVO.getSubjectName();
                String index = manualAddVO.getIndex();
                SpecialInformation subjectdatabase = (SpecialInformation) esOpUtil.getInfoById(index, id, SpecialInformation.class);
                String dataId = subjectId + id;
                subjectdatabase.setId(dataId);
                subjectdatabase.setProcessDate(DateUtil.dateToString(new Date(), "yyyy-MM-dd'T'HH:mm:ss"));
                subjectdatabase.setSubjectId(subjectId);
                subjectdatabase.setSubjectName(subjectName);
                subjectdatabase.setDeleteFlag(0);
                subjectdatabase.setCheckStatus(0);
                subjectdatabase.setTopNum(0);
                esOpUtil.docSaveByJson(Constants.SUBJECT_INDEX + "_" + LocalDateTime.now().getYear(), dataId, JSON.toJSONString(subjectdatabase));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean duplicationByTitleOrSourceAddress(DisplayInfo displayInfo) {
        return esService.duplicationByTitleOrSourceAddress(displayInfo);
    }

    @Override
    public void add(DisplayInfo displayInfo, Integer category, UserVo userVo) {
        SpecialInformation specialInformation = new SpecialInformation();
        BeanUtils.copyProperties(displayInfo, specialInformation);
        String id = specialInformation.getSubjectId() + codeGenerateUtil.geneIdNo(Constants.DATA_ADD_ID, 8);
        specialInformation.setId(id);
        specialInformation.setUniqueCode(id);
        specialInformation.setDeleteFlag(0);
        specialInformation.setCheckStatus(0);
        specialInformation.setTopNum(0);
        specialInformation.setFlag("1");
        specialInformation.setCreateDate(EsDateUtil.esFieldDateFormat(cn.hutool.core.date.DateUtil.formatDateTime(new Date())));
        specialInformation.setProcessDate(EsDateUtil.esFieldDateFormat(cn.hutool.core.date.DateUtil.formatDateTime(new Date())));
        specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(specialInformation.getPublishDate()));
        specialInformation.setMasterEntryId(specialInformation.getId());
        if (displayInfo.getYnArticle()) {
            //加上分类
            setInfoSourceType(specialInformation);
        }
        //用户信息
        String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
        //检查是否有附件信息
        if (ObjectUtils.isNotEmpty(specialInformation.getAttachmentInfos())) {

            specialInformation.getAttachmentInfos().forEach(e -> {
                ClbSysAttachment attachmentInfo = new ClbSysAttachment();
                attachmentInfo.setTypeId("6");
                attachmentInfo.setName(e.getAttachmentName());
                attachmentInfo.setGroupName(e.getGroup());
                attachmentInfo.setPath(e.getAttachmentPath());
                attachmentInfo.setFullPath(e.getAttachmentFullPath());
                attachmentInfo.setCategory(e.getCategory());
                attachmentInfo.setFileSize(e.getFileSize());
                attachmentInfo.setItemId(specialInformation.getId());
                attachmentInfo.setStatus(1);
                attachmentInfo.setOrderBy(0);
                attachmentInfo.setSource("");
                attachmentInfo.setYear(cn.hutool.core.date.DateUtil.thisYear());
                clbSysAttachmentService.save(attachmentInfo);
                e.setAttachmentId(attachmentInfo.getId().toString());
            });
        }
        //更新content字段
        if (StringUtils.isNotBlank(specialInformation.getContentWithTag())) {
            String content = Jsoup.parse(specialInformation.getContentWithTag()).text();
            specialInformation.setContent(content);
            //base64图片转url
            specialInformation.setContentWithTag(imageUtil.changeBase64ToUrl(specialInformation.getContentWithTag()));
        }
        if (StringUtils.isNotBlank(specialInformation.getContentWithTagRaw())) {
            String contentRaw = Jsoup.parse(specialInformation.getContentWithTagRaw()).text();
            specialInformation.setContentRaw(contentRaw);
            //base64图片转url
            specialInformation.setContentWithTag(imageUtil.changeBase64ToUrl(specialInformation.getContentWithTag()));
        }
        esOpUtil.docSavaByEntity(EsIndexUtil.getIndexYear(Constants.SUBJECT_INDEX), specialInformation.getId(), specialInformation);
        // 发送数据生命周期日志  入专题库 新增消息到kafka
        final Subjectdatabase subjectdatabase = new Subjectdatabase();
        BeanUtil.copyProperties(specialInformation, subjectdatabase, CopyOptions.create().ignoreError().ignoreNullValue());
        String subjectName = subjectdatabase.getSubjectName();
        if (StringUtils.isEmpty(subjectName)) {
            String subjectId = subjectdatabase.getSubjectId();
            if (category == 1) {
                Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                        .eq(Subject::getId, subjectId)
                        .select(Subject::getSubjectName));
                subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
            } else if (category == 2) {
                Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                        .eq(Event::getId, subjectId)
                        .select(Event::getEventName));
                subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
            }
            subjectdatabase.setSubjectName(subjectName);
        }

        final DataLifecycleLog toSubjectLog = DataLifecycleLog.createToSubjectLog(subjectdatabase, operateUser);
        kafkaTemplate.send("data_lifecycle_log_to_subject", JSONUtil.toJsonStr(toSubjectLog));
    }

    @Override
    public void updateInfo(JSONObject jsonObject, UserVo userVo) {
        SpecialInformation specialInformation = JSON.parseObject(JSON.toJSONString(jsonObject.get("data")), SpecialInformation.class);
        Integer category = (Integer) jsonObject.get("category");
        String index = specialInformation.getDbIndex();
        specialInformation.setIndex(null);
        //更新content字段
        if (StringUtils.isNotBlank(specialInformation.getContentWithTag())) {
            String content = Jsoup.parse(specialInformation.getContentWithTag()).text();
            specialInformation.setContent(content);
            //base64图片转url
            specialInformation.setContentWithTag(imageUtil.changeBase64ToUrl(specialInformation.getContentWithTag()));
        }
        if (StringUtils.isNotBlank(specialInformation.getContentWithTagRaw())) {
            String contentRaw = Jsoup.parse(specialInformation.getContentWithTagRaw()).text();
            specialInformation.setContentRaw(contentRaw);
            //base64图片转url
            specialInformation.setContentWithTag(imageUtil.changeBase64ToUrl(specialInformation.getContentWithTag()));
        }
        //处理时间格式
        specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(specialInformation.getPublishDate()));
        specialInformation.setCreateDate(EsDateUtil.esFieldDateFormat(specialInformation.getCreateDate()));
        specialInformation.setUpdateDate(EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date())));
        ESData esData = new ESData();
        BeanUtil.copyProperties(specialInformation, esData);
        esOpUtil.docUpdateById(index, specialInformation.getId(), JSON.toJSONString(esData));
        //修改信息源的原创新
        if (StringUtils.isNotBlank(specialInformation.getOriginalSource())) {
            infoSourceService.update(Wrappers.<InfoSource>lambdaUpdate().eq(InfoSource::getId, specialInformation.getSid())
                    .set(InfoSource::getOriginalSource, specialInformation.getOriginalSource()));
        }
        //发送 人工操作 日志
        CompletableFuture.runAsync(() -> sendManualKafkaMsg(category, specialInformation, EnumOperateWay.EDITED, null, userVo));
    }

    @Override
    public void modifyLabel(DataBindLabelFrom dataBindLabelFrom) {
        List<DictVO> boundList = dataBindLabelFrom.getBindList();
        List<String> labelMarks = new ArrayList<>();
        for (DictVO dictVO : boundList) {
            if (StringUtils.isNotEmpty(dictVO.getCode())) {
                labelMarks.add(dictVO.getCode());
            } else {
                labelMarks.add(dictVO.getLabelMark());
            }
        }
        List<Label> dbLabels = esService.getLabelsById(dataBindLabelFrom.getIndex(), dataBindLabelFrom.getId());
        List<Label> newLabels = new ArrayList<>();
        List<SysDictItem> dictItemList = dataBindLabelFrom.getDictItemList();
        for (SysDictItem sysDictItem : dictItemList) {
            Label label = new Label();
            label.setRelationId(sysDictItem.getId());
            label.setLabelMark(sysDictItem.getDictCode());
            label.setRelationName(sysDictItem.getItemText());
            newLabels.add(label);
        }

        if (CollectionUtils.isNotEmpty(dbLabels)) {
            List<Label> collect = dbLabels.stream().filter(label -> labelMarks.contains(label.getLabelMark())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                List<String> dictItemIds = new ArrayList<>();
                dictItemList.forEach(sysDictItem -> dictItemIds.add(sysDictItem.getId()));
                for (Label label : collect) {
                    if (dictItemIds.contains(label.getRelationId())) {
                        //数据库中已存在的标签以当前存储为主，不做更新
                        newLabels.removeIf(item -> item.getRelationId().equals(label.getRelationId()));
                        newLabels.add(label);
                    }
                }
            }
            List<Label> otherCollect = dbLabels.stream().filter(label -> !labelMarks.contains(label.getLabelMark())).collect(Collectors.toList());
            newLabels.addAll(otherCollect);
        }
        esService.updateLabelsById(dataBindLabelFrom.getIndex(), dataBindLabelFrom.getId(), newLabels);
    }

    @Override
    public void checkInfo(Map<String, Object> map, UserVo userVo) {
        List<Map<String, String>> ids = (List<Map<String, String>>) map.get("ids");
        Integer checkStatus = (Integer) map.get("checkStatus");
        Integer category = (Integer) map.get("category");
        for (Map<String, String> m : ids) {
            String index = m.get("index");
            String id = m.get("id");
            Map<String, Object> updateFields = new HashMap<>();
            updateFields.put("checkStatus", checkStatus);
            updateFields.put("deleteFlag", 0);
            String operateDate = EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date()));
            updateFields.put("updateDate", operateDate);
            updateFields.put("checkDate", operateDate);
            esOpUtil.updateById(index, id, updateFields);
            // 发送生命周期日志到kafka
            CompletableFuture.runAsync(() -> {
                final DataLifecycleLog dataCheckLog;
                final Subjectdatabase subjectdatabase = (Subjectdatabase) esOpUtil.getInfoById(index, id, Subjectdatabase.class);
                String subjectName = subjectdatabase.getSubjectName();
                if (StringUtils.isEmpty(subjectName)) {
                    String subjectId = subjectdatabase.getSubjectId();
                    if (category == 1) {
                        Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                                .eq(Subject::getId, subjectId)
                                .select(Subject::getSubjectName));
                        subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
                    } else if (category == 2) {
                        Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                                .eq(Event::getId, subjectId)
                                .select(Event::getEventName));
                        subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
                    }
                    subjectdatabase.setSubjectName(subjectName);
                }
                String sourceName;
                final InfoSource infoSource = infoSourceService.getOne(new QueryWrapper<InfoSource>()
                        .eq("id", subjectdatabase.getSid())
                        .select("site_name"));
                if (infoSource == null) {
                    sourceName = Optional.ofNullable(
                                    keyWordsService.getOne(new QueryWrapper<KeyWords>()
                                            .eq("id", subjectdatabase.getSid())
                                            .select("words_name")))
                            .orElse(new KeyWords())
                            .getWordsName();
                } else {
                    sourceName = infoSource.getWebSiteName();
                }
                final String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
                if (checkStatus == 1) {
                    dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.RETAINED);
                } else if (checkStatus == 0) {
                    dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.RETAIN_CANCELED);
                } else {
                    dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.TEMPORARY);
                }
                kafkaTemplate.send("data_lifecycle_log_data_check", JSONUtil.toJsonStr(dataCheckLog));
            });
        }
    }

    @Override
    public void deleteBatch(Map<String, Object> map, UserVo userVo) {
        List<Map<String, String>> ids = (List<Map<String, String>>) map.get("ids");
        Integer deleteFlag = (Integer) map.get("deleteFlag");
        Integer category = (Integer) map.get("category");
        for (Map<String, String> m : ids) {
            String index = m.get("index");
            String id = m.get("id");
            Map<String, Object> updateFields = new HashMap<>();
            updateFields.put("checkStatus", 0);
            updateFields.put("deleteFlag", deleteFlag);
            String operateDate = EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date()));
            updateFields.put("updateDate", operateDate);
            updateFields.put("checkDate", operateDate);
            esOpUtil.updateById(index, id, updateFields);
            // 发送生命周期日志到kafka
            CompletableFuture.runAsync(() -> {
                final DataLifecycleLog dataCheckLog;
                final Subjectdatabase subjectdatabase = (Subjectdatabase) esOpUtil.getInfoById(index, id, Subjectdatabase.class);
                String subjectName = subjectdatabase.getSubjectName();
                if (StringUtils.isEmpty(subjectName)) {
                    String subjectId = subjectdatabase.getSubjectId();
                    if (category == 1) {
                        Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                                .eq(Subject::getId, subjectId)
                                .select(Subject::getSubjectName));
                        subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
                    } else if (category == 2) {
                        Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                                .eq(Event::getId, subjectId)
                                .select(Event::getEventName));
                        subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
                    }
                    subjectdatabase.setSubjectName(subjectName);
                }
                String sourceName;
                final InfoSource infoSource = infoSourceService.getOne(new QueryWrapper<InfoSource>()
                        .eq("id", subjectdatabase.getSid())
                        .select("site_name"));
                if (infoSource == null) {
                    sourceName = Optional.ofNullable(
                                    keyWordsService.getOne(new QueryWrapper<KeyWords>()
                                            .eq("id", subjectdatabase.getSid())
                                            .select("words_name")))
                            .orElse(new KeyWords())
                            .getWordsName();
                } else {
                    sourceName = infoSource.getWebSiteName();
                }
                final String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
                dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.DELETED);
                kafkaTemplate.send("data_lifecycle_log_data_check", JSONUtil.toJsonStr(dataCheckLog));
            });
        }
    }

    @Override
    public void removeBatch(Map<String, Object> map) {
        ArrayList<Map<String, String>> ids = (ArrayList<Map<String, String>>) map.get("ids");
        //判断ids字段是否为空
        if (ids != null && !ids.isEmpty()) {
            esOpUtil.docRemoveBulk(ids);
        }
    }

    @Override
    public void topInfo(SubjectInfoVo subjectInfoVo, UserVo userVo) {
        Integer category = subjectInfoVo.getCategory();
        String index = subjectInfoVo.getIndex();
        Integer type = subjectInfoVo.getType();
        String id = subjectInfoVo.getId();
        Map<String, Object> updateFields = new HashMap<>();
        if (type == 0) {
            updateFields.put("topNum", 0);
        } else {
            //先查询出库里面最大的置顶id
            int topNum = esService.getTopNum(index, subjectInfoVo.getSubjectId());
            updateFields.put("topNum", topNum + 1);
        }
        updateFields.put("updateDate", EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
        esOpUtil.updateById(index, id, updateFields);
        //发送 人工操作 日志
        CompletableFuture.runAsync(() -> {
            SpecialInformation specialInformation = (SpecialInformation) esOpUtil.getInfoById(index, subjectInfoVo.getId(), SpecialInformation.class);
            if (type == 0) {
                sendManualKafkaMsg(category, specialInformation, EnumOperateWay.TOP_CANCELED, null, userVo);
            } else {
                sendManualKafkaMsg(category, specialInformation, EnumOperateWay.TOP, null, userVo);
            }
        });
    }

    @Override
    public void collect(CollectionInfo collectionInfo) {
        UserVo userVo = UserUtil.getLoginUser();
        String userId = userVo.getId();
        CollectionMap collectionMap = new CollectionMap();
        BeanUtils.copyProperties(collectionInfo, collectionMap);
        collectionMap.setUserId(userId);
        String type = collectionInfo.getType();
        if ("1".equals(type)) {
            collectionMap.setEsIndex(collectionInfo.getIndex());
            collectionMapService.save(collectionMap);
        } else {
            QueryWrapper<CollectionMap> query = Wrappers.query();
            query.eq("user_id", userId);
            query.eq("article_id", collectionMap.getArticleId());
            collectionMapService.remove(query);
        }
        //发送 人工操作 日志
        CompletableFuture.runAsync(() -> {
            Integer category = collectionInfo.getCategory();
            SpecialInformation specialInformation = (SpecialInformation) esOpUtil.getInfoById(collectionInfo.getIndex(), collectionInfo.getArticleId(), SpecialInformation.class);
            if ("1".equals(type)) {
                sendManualKafkaMsg(category, specialInformation, EnumOperateWay.COLLECTED, null, userVo);
            } else {
                sendManualKafkaMsg(category, specialInformation, EnumOperateWay.COLLECT_CANCELED, null, userVo);
            }
        });
    }

    @Override
    public List<StatisticsKeyWordVo> hotWords(String index, String id, Integer number) {
        SubjectDataVo subjectDataVo = esService.queryInfo(index, id);
        String content = subjectDataVo.getContent();
        List<Map.Entry<String, Integer>> keywordsList = HanlpUtil.extractKeyWordsByText(Jsoup.parse(content).text(), number);
        List<StatisticsKeyWordVo> rn = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(keywordsList)) {
            for (Map.Entry<String, Integer> entry : keywordsList) {
                StatisticsKeyWordVo statisticsKeyWordVo = new StatisticsKeyWordVo();
                statisticsKeyWordVo.setName(entry.getKey());
                statisticsKeyWordVo.setValue(entry.getValue());
                rn.add(statisticsKeyWordVo);
            }
        }
        return rn;
    }

    @Override
    public List<SubjectDataVo> recommendList(String subjectId, String id, String title, Integer pageNo, Integer pageSize) {
        return esService.queryRecommendList(subjectId, id, title, pageNo, pageSize);
    }

    //导入发布库数据
    @Override
    public void importInfo(List<List<String>> lists, String subjectId, String isTopping, String isExamine, ClbFileOperationLog clbFileOperationLog, UserVo userVo) {
        if (null == clbFileOperationLog) {
            clbFileOperationLog = clbFileOperationLogService.operationStart(userVo);
            clbFileOperationLog.setSubjectId(subjectId);
        }
        for (List<String> info : lists) {

            try {
                SpecialInformation specialInformation = new SpecialInformation();
                specialInformation.setId(codeGenerateUtil.geneIdNo(Constants.DATA_ADD_ID, 8));
                //判断正文是否为空
                if (StringUtils.isEmpty(info.get(3))) {
                    ClbFileOperationLogDetails clbFileOperationLogDetails = clbFileOperationLogDetailsService.buildFailDetails(info.get(1), info.get(5), info.get(7), "资讯内容为空");
                    clbFileOperationLog.getClbFileOperationLogDetails().add(clbFileOperationLogDetails);
                    continue;
                }
                if (StringUtils.isNotEmpty(info.get(0))) {
                    specialInformation.setScore(Double.valueOf(info.get(0)));
                }
                if (StringUtils.isNotEmpty(info.get(1))) {
                    specialInformation.setTitle(info.get(1));
                }
                if (StringUtils.isNotEmpty(info.get(2))) {
                    specialInformation.setSummary(info.get(2));
                }
                if (StringUtils.isNotEmpty(info.get(3))) {
                    specialInformation.setContent(info.get(3));
                }
                if (StringUtils.isNotEmpty(info.get(4))) {
                    specialInformation.setAuthor(info.get(4));
                }
                if (StringUtils.isNotEmpty(info.get(5))) {
                    specialInformation.setOrigin(info.get(5));
                }
                if (StringUtils.isNotEmpty(info.get(6))) {
                    specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(info.get(6)));
                }
                if (StringUtils.isNotEmpty(info.get(7))) {
                    specialInformation.setSourceAddress(info.get(7));
                }
                //0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例
                if (StringUtils.isNotEmpty(info.get(8))) {
                    if ("政策".equals(info.get(8))) {
                        specialInformation.setClassificationType(1);
                    } else if ("领导讲话".equals(info.get(8))) {
                        specialInformation.setClassificationType(2);
                    } else if ("专家观点".equals(info.get(8))) {
                        specialInformation.setClassificationType(3);
                    } else if ("企业案例".equals(info.get(8))) {
                        specialInformation.setClassificationType(4);
                    } else {
                        specialInformation.setClassificationType(0);
                    }
                }
                specialInformation.setDeleteFlag(0);
                specialInformation.setTopNum(0);
                specialInformation.setSubjectId(subjectId);
                specialInformation.setFlag("1");
                specialInformation.setMasterEntryId(specialInformation.getId());
                specialInformation.setDataFrom(1);
                //加上分类
                setInfoSourceType(specialInformation);
                //判断是否需要审核
                if (StringUtils.isNotEmpty(isExamine) && "false".equals(isExamine)) {
                    specialInformation.setCheckStatus(1);
                }
                //判断是否置顶
                if (StringUtils.isNotEmpty(isTopping) && "true".equals(isTopping)) {
                    int topNum = esService.getTopNum(null, subjectId);
                    specialInformation.setTopNum(topNum + 1);
                }
                specialInformation.setCreateDate(cn.hutool.core.date.DateUtil.format(new Date(), "yyyy-MM-dd'T'HH:mm:ss"));
                specialInformation.setProcessDate(specialInformation.getCreateDate());
                esOpUtil.docSavaByEntity(EsIndexUtil.getIndexYear(Constants.SUBJECT_INDEX), specialInformation.getId(), specialInformation);
                clbFileOperationLog.getClbFileOperationLogDetails().add(clbFileOperationLogDetailsService.buildFailDetails(info.get(1), info.get(5), info.get(7)));
            } catch (NumberFormatException e) {
                ClbFileOperationLogDetails clbFileOperationLogDetails = clbFileOperationLogDetailsService.buildFailDetails(info.get(1), info.get(5), info.get(7), "插入es异常" + e.getMessage());
                clbFileOperationLog.getClbFileOperationLogDetails().add(clbFileOperationLogDetails);
            }

        }
        clbFileOperationLogService.saveEntity(clbFileOperationLog);
    }

    @Override
    public void importDataInfo(List<FileDataVO> lists, String subjectId) {
        if (CollectionUtil.isNotEmpty(lists)) {
            String index = Constants.SUBJECT_INDEX + "_" + DateUtils.getYear();
            List<SpecialInformation> dataList = new ArrayList<>();
            for (FileDataVO info : lists) {
                SpecialInformation specialInformation = new SpecialInformation();
                specialInformation.setId(codeGenerateUtil.geneIdNo(Constants.DATA_ADD_ID, 8));
                if (StringUtils.isNotEmpty(info.getTitle())) {
                    specialInformation.setTitle(info.getTitle());
                }
                if (StringUtils.isNotEmpty(info.getAuthor())) {
                    specialInformation.setAuthor(info.getAuthor());
                }
                if (StringUtils.isNotEmpty(info.getOrigin())) {
                    specialInformation.setOrigin(info.getOrigin());
                    specialInformation.setSid(info.getOrigin());
                }
                String library = info.getClassificationType();
                if (StringUtils.isNotEmpty(library)) {
                    SysDictItem dictItem = sysDictItemService.dictItemInfoByName("Thematic_Library", library);
                    if (dictItem != null) {
                        specialInformation.setClassificationType(Integer.parseInt(dictItem.getItemValue()));
                    } else {
                        specialInformation.setClassificationType(0);
                    }
                } else {
                    specialInformation.setClassificationType(0);
                }
                if (StringUtils.isNotEmpty(info.getSourceAddress())) {
                    specialInformation.setSourceAddress(info.getSourceAddress());
                }
                if (StringUtils.isNotEmpty(info.getPublishDate())) {
                    specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(info.getPublishDate()));
                }
                if (StringUtils.isNotEmpty(info.getContent())) {
                    specialInformation.setContent(info.getContent());
                }
                if (StringUtils.isNotEmpty(info.getSummary())) {
                    specialInformation.setContent(info.getSummary());
                }
                specialInformation.setCheckStatus(1);
                specialInformation.setDeleteFlag(0);
                specialInformation.setTopNum(0);
                specialInformation.setDataFrom(1);
                specialInformation.setScore(0D);
                specialInformation.setSubjectId(subjectId);
                String format = DateUtil.dateToString(new Date(), "yyyy-MM-dd'T'HH:mm:ss");
                specialInformation.setCreateDate(format);
                specialInformation.setProcessDate(format);
                //加上分类
                setInfoSourceType(specialInformation);
                //匹配标签
                List<Label> labels = getInfoSourceLabel(specialInformation.getOrigin(), specialInformation.getSourceAddress());
                specialInformation.setLabels(labels);
                dataList.add(specialInformation);
            }
            esOpUtil.docSaveBulk(index, dataList);
        }
    }

    @Override
    public void removeByCondition(String subjectId, List<String> themeIds) {
        InfoDataSearchCondition searchCondition = new InfoDataSearchCondition();
        searchCondition.setSubjectId(subjectId);
        searchCondition.setLabelIds(themeIds);
        searchCondition.setPageSize(300);
        String[] fetchFields = new String[]{"id", "labels"};
        searchCondition.setFetchFields(fetchFields);
        List<SpecialInformation> dataList = new ArrayList<>();
        List<SpecialInformation> removeList = new ArrayList<>();
        for (int i = 1; ; i++) {
            searchCondition.setPageNo(i);
            List<SpecialInformation> informationList = esService.informationList(searchCondition);
            log.info("本次循环-{}，数据量为-{}", i, informationList.size());
            if (CollectionUtils.isEmpty(informationList)) {
                break;
            }
            for (SpecialInformation specialInformation : informationList) {
                List<Label> labels = specialInformation.getLabels();
                List<Label> collect = labels.stream().filter(e -> "thematic_information_column".equals(e.getLabelMark())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    if (collect.size() == 1) {
                        removeList.add(specialInformation);
                    } else {
                        List<Label> newLabels = new ArrayList<>();
                        for (Label label : collect) {
                            String labelRelationId = label.getRelationId();
                            if (!themeIds.contains(labelRelationId)) {
                                newLabels.add(label);
                            }
                        }
                        specialInformation.setLabels(newLabels);
                        specialInformation.setUpdateDate(EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
                        dataList.add(specialInformation);
                    }
                } else {
                    removeList.add(specialInformation);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(removeList)) {
            Map<String, List<SpecialInformation>> removeMap = removeList.stream().collect(Collectors.groupingBy(SpecialInformation::getDbIndex));
            esOpUtil.docRemoveBulk(removeMap);
        }
        if (CollectionUtils.isNotEmpty(dataList)) {
            Map<String, List<SpecialInformation>> updateMap = removeList.stream().collect(Collectors.groupingBy(SpecialInformation::getDbIndex));
            updateMap.forEach((k, v) -> esOpUtil.docUpdateBulk(k, v));
        }
        //python 去重接口
        pythonUtil.clearDuplicateHistory(themeIds);
    }

    @Override
    public void supplyByCondition(String subjectId, List<String> themeIds) {
        List<String> bindSubjectIds = subjectMapper.getBindSubjectIds(subjectId);
        Subject subject = subjectService.getById(subjectId);
        String startTime = esService.getFirstTime(bindSubjectIds, "asc");
        String endTime = esService.getFirstTime(bindSubjectIds, "desc");
        List<String> dateList = DateUtil.betweenDate(startTime, endTime);
        if (CollectionUtils.isNotEmpty(dateList)) {
            List<String> redisCacheList = new ArrayList<>();
            for (String date : dateList) {
                if (themeIds != null && !themeIds.isEmpty()) {
                    //2025-01-21:123,123,123
                    String dateStr = date + ":" + StringUtils.join(",", themeIds);
                    redisCacheList.add(dateStr);
                } else {
                    redisCacheList.add(date);
                }
            }
            redisUtil.rpushMultipleValues(Constants.HISTORY_SUBJECT_DATE_QUEUE + subject.getSubjectCode(), redisCacheList.toArray(new String[0]));
        }
    }

    @Override
    public List<SpecialInformation> informationAllList(InfoDataSearchCondition searchCondition) {
        List<SpecialInformation> informationList = new ArrayList<>();
        Integer num = searchCondition.getNum();
        if (num == null) {
            searchCondition.setPageSize(300);
            for (int i = 1; ; i++) {
                searchCondition.setPageNo(i);
                List<SpecialInformation> list = esService.informationList(searchCondition);
                log.info("本次循环-{}，数据量为-{}", i, list.size());
                if (CollectionUtils.isEmpty(list)) {
                    break;
                }
                informationList.addAll(list);
            }
        } else {
            informationList = esService.informationList(searchCondition);
        }
        return informationList;
    }

    @Override
    public void removeLabelById(String index, String id, String relationId) {
        List<Label> labels = esService.getLabelsById(index, id);
        if (labels == null) {
            return;
        }
        labels.removeIf(e -> e.getRelationId().equals(relationId));
        esService.updateLabelsById(index, id, labels);
    }

    @Override
    public void removeWordLabel(InfoDataSearchCondition searchCondition) {
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        BoolQueryBuilder buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        buildQuery.must(QueryBuilders.nestedQuery("sortField",
                QueryBuilders.termsQuery("sortField.fieldType", searchCondition.getKeywordList()),
                ScoreMode.None));
        List<String> keywordList = searchCondition.getKeywordList();
        for (String word : keywordList) {
            Map<String, Object> deleteParams = new HashMap<>();
            deleteParams.put("fieldType", word);
            long start = System.currentTimeMillis();
            esOpUtil.batchNestedDeleteScript(indexArr, buildQuery, deleteParams, "sortField");
            log.info("删除关键词-{},耗时：{}",word, System.currentTimeMillis()-start);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addToFavorites(InfoDataSearchCondition searchCondition) {
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        List<String> ids = searchCondition.getIds();
        BoolQueryBuilder buildQuery;
        if (CollectionUtils.isEmpty(ids)) {
            buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        } else {
            buildQuery = QueryBuilders.boolQuery().must(QueryBuilders.termsQuery("id", ids));
        }
        Map<String, Object> modifyParams = new HashMap<>();
        modifyParams.put("checkStatus", 1);
        modifyParams.put("deleteFlag",0);
        modifyParams.put("updateDate",EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
        long start = System.currentTimeMillis();
        esOpUtil.batchUpdateScript(indexArr, buildQuery, modifyParams);
        log.info("添加到精选,耗时：{}", System.currentTimeMillis()-start);
    }

    @Override
    public void addToPend(InfoDataSearchCondition searchCondition) {
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        List<String> ids = searchCondition.getIds();
        BoolQueryBuilder buildQuery;
        if (CollectionUtils.isEmpty(ids)) {
            buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        } else {
            buildQuery = QueryBuilders.boolQuery().must(QueryBuilders.termsQuery("id", ids));
        }
        Map<String, Object> modifyParams = new HashMap<>();
        modifyParams.put("checkStatus",3);
        modifyParams.put("deleteFlag",0);
        modifyParams.put("updateDate",EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
        long start = System.currentTimeMillis();
        esOpUtil.batchUpdateScript(indexArr, buildQuery, modifyParams);
        log.info("添加到待定,耗时：{}", System.currentTimeMillis()-start);
    }

    @Override
    public void addToRemove(InfoDataSearchCondition searchCondition) {
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        List<String> ids = searchCondition.getIds();
        BoolQueryBuilder buildQuery;
        if (CollectionUtils.isEmpty(ids)) {
            buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        } else {
            buildQuery = QueryBuilders.boolQuery().must(QueryBuilders.termsQuery("id", ids));
        }
        Map<String, Object> modifyParams = new HashMap<>();
        modifyParams.put("deleteFlag",1);
        modifyParams.put("updateDate",EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
        long start = System.currentTimeMillis();
        esOpUtil.batchUpdateScript(indexArr, buildQuery, modifyParams);
        log.info("添加到删除,耗时：{}", System.currentTimeMillis()-start);
    }

    @Override
    public void initialData(InfoDataSearchCondition searchCondition) {
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        BoolQueryBuilder buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        Map<String, Object> modifyParams = new HashMap<>();
        modifyParams.put("checkStatus",0);
        modifyParams.put("deleteFlag",0);
        modifyParams.put("updateDate",EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
        long start = System.currentTimeMillis();
        esOpUtil.batchUpdateScript(indexArr, buildQuery, modifyParams);
        log.info("初始化数据,耗时：{}", System.currentTimeMillis()-start);
    }

    @Override
    public IPage<SpecialInformation> searchForReplaceList(InfoDataSearchCondition searchCondition) {
        return esService.searchForReplaceList(searchCondition);
    }

    @Override
    public void charReplace(InfoDataSearchCondition searchCondition) {
        SearchWordVO searchWordVO = searchCondition.getSearchWordList().get(0);
        Integer searchScope = searchWordVO.getSearchScope();
        String oldWord = searchWordVO.getSearchInfo();
        String newWord = searchCondition.getReplaceWord();
        if(StringUtils.isEmpty(newWord)) {
            newWord = "";
        }
        List<String> modifyFields = new ArrayList<>();
        if (searchScope == 1) {
            modifyFields.add("title");
        } else if (searchScope == 2) {
            modifyFields.add("content");
            modifyFields.add("contentWithTag");
        } else if (searchScope == 3) {
            modifyFields.add("title");
            modifyFields.add("content");
            modifyFields.add("contentWithTag");
        } else if (searchScope == 4) {
            modifyFields.add("origin");
        }
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        BoolQueryBuilder buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        long start = System.currentTimeMillis();
        esOpUtil.batchReplaceScript(indexArr, buildQuery, modifyFields, oldWord, newWord);
        log.info("字符串替换-{},耗时：{}", oldWord,System.currentTimeMillis()-start);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        Map<String, Object> modifyParams = new HashMap<>();
        modifyParams.put("updateDate",EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
        esOpUtil.batchUpdateScript(indexArr, buildQuery, modifyParams);
    }

    @Override
    public void markTag(InfoDataSearchCondition searchCondition) {
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        List<String> ids = searchCondition.getIds();
        BoolQueryBuilder buildQuery;
        if (CollectionUtils.isEmpty(ids)) {
            buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        } else {
            buildQuery = QueryBuilders.boolQuery().must(QueryBuilders.termsQuery("id", ids));
        }
        Map<String, Object> addParams = new HashMap<>();
        for (Label markTag : searchCondition.getMarkTags()) {
            Map<String, String> addTag = ObjectUtil.objectToMap(markTag);
            addParams.put("labels",addTag);
            long start = System.currentTimeMillis();
            esOpUtil.batchNestedAddScript(indexArr, buildQuery, addParams,"labels","relationId");
            log.info("打标-{},耗时：{}", markTag.getRelationName(),System.currentTimeMillis()-start);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            Map<String, Object> modifyParams = new HashMap<>();
            modifyParams.put("updateDate",EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
            esOpUtil.batchUpdateScript(indexArr, buildQuery, modifyParams);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void removeTag(InfoDataSearchCondition searchCondition) {
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(searchCondition.getSubjectId());
        String minCreateTime = subjectService.getMinCreateTime(subjectIdList);
        String[] indexArr = EsIndexUtil.getIndexIntervalYearStr(Constants.SUBJECT_INDEX, minCreateTime);
        List<String> ids = searchCondition.getIds();
        BoolQueryBuilder buildQuery;
        if (CollectionUtils.isEmpty(ids)) {
            buildQuery = esService.buildQuery(searchCondition, subjectIdList);
        } else {
            buildQuery = QueryBuilders.boolQuery().must(QueryBuilders.termsQuery("id", ids));
        }
        List<Label> markTags = searchCondition.getMarkTags();
        List<String> tagIds = markTags.stream().map(Label::getRelationId).collect(Collectors.toList());
        buildQuery.must(QueryBuilders.nestedQuery("labels",
                QueryBuilders.termsQuery("labels.relationId", tagIds),
                ScoreMode.None));
        for (Label markTag : markTags) {
            Map<String, Object> deleteParams = new HashMap<>();
            deleteParams.put("relationId", markTag.getRelationId());
            long start = System.currentTimeMillis();
            esOpUtil.batchNestedDeleteScript(indexArr, buildQuery, deleteParams, "labels");
            log.info("删除标签-{},耗时：{}", markTag.getRelationName(),System.currentTimeMillis()-start);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            Map<String, Object> modifyParams = new HashMap<>();
            modifyParams.put("updateDate",EsDateUtil.esFieldDateFormat(DateUtils.formatDateTime()));
            esOpUtil.batchUpdateScript(indexArr, buildQuery, modifyParams);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void formatLabel(List<LabelModelVo> labelModelVos, DisplayInfo info) {
        if (CollectionUtils.isNotEmpty(labelModelVos)) {
            List<Label> list = info.getLabels();
            List<LabelInfo> labelInfos = new ArrayList<>();
            //获取专题打的标签
            for (LabelModelVo labelModelVo : labelModelVos) {
                LabelInfo labelInfo = new LabelInfo();
                labelInfo.setLabelId(labelModelVo.getLabelId());
                labelInfo.setLabelName(labelModelVo.getLabelName());
                labelInfo.setLabelType(labelModelVo.getLabelType());
                labelInfo.setLabelMark(labelModelVo.getLabelMark());
                List<Label> labelList = new ArrayList<>();
                if (list != null && !list.isEmpty()) {
                    for (Label label : list) {
                        if (StringUtils.isNotBlank(label.getLabelMark()) &&
                                (label.getLabelMark().contains(labelModelVo.getLabelMark()) || ("company_label".equals(labelModelVo.getLabelType()) && "company_label".equals(label.getLabelRemarks())))) {
                            labelList.add(label);
                        }
                    }
                }
                labelInfo.setLabelList(labelList);
                labelInfos.add(labelInfo);
            }
            info.setLabelInfos(labelInfos);
        }
    }


    private void addReadNum(DisplayInfo displayInfo, String index) {
        if (displayInfo != null) {
            Long readNum = displayInfo.getReadNum();
            if (readNum == 0) {
                readNum = 1L;
            } else {
                readNum = readNum + 1;
            }
            Map<String, Object> updateFieldMap = new HashMap<>();
            updateFieldMap.put("readNum", readNum);
            esOpUtil.updateById(index, displayInfo.getId(), updateFieldMap);
        }
    }

    //发送 人工操作 日志
    private void sendManualKafkaMsg(Integer category, SpecialInformation specialInformation, EnumOperateWay enumOperateWay, List<String> labelNameList, UserVo userVo) {
        // 发送数据生命周期日志  数据审核 编辑标签消息到kafka
        final DataLifecycleLog manualOperateLog;
        final Subjectdatabase subjectdatabase = new Subjectdatabase();
        BeanUtil.copyProperties(specialInformation, subjectdatabase, CopyOptions.create().ignoreError().ignoreNullValue());
        String subjectName = subjectdatabase.getSubjectName();
        if (StringUtils.isEmpty(subjectName)) {
            String subjectId = subjectdatabase.getSubjectId();
            if (category == 1) {
                Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                        .eq(Subject::getId, subjectId)
                        .select(Subject::getSubjectName));
                subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
            } else if (category == 2) {
                Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                        .eq(Event::getId, subjectId)
                        .select(Event::getEventName));
                subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
            }
            subjectdatabase.setSubjectName(subjectName);
        }
        String sourceName;
        final InfoSource infoSource = infoSourceService.getOne(new QueryWrapper<InfoSource>()
                .eq("id", subjectdatabase.getSid())
                .select("site_name"));
        if (infoSource == null) {
            sourceName = Optional.ofNullable(
                            keyWordsService.getOne(new QueryWrapper<KeyWords>()
                                    .eq("id", subjectdatabase.getSid())
                                    .select("words_name")))
                    .orElse(new KeyWords())
                    .getWordsName();
        } else {
            sourceName = infoSource.getWebSiteName();
        }
        final String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
        manualOperateLog = DataLifecycleLog.createManualOperateLog(subjectdatabase, operateUser, enumOperateWay, sourceName, labelNameList);
        kafkaTemplate.send("data_lifecycle_log_manual_operate", JSONUtil.toJsonStr(manualOperateLog));
    }


    //信息加上分类
    public void setInfoSourceType(SpecialInformation data) {
        String url = Utility.domainURL(data.getSourceAddress());
        String typeNum;
        if (StringUtils.isNotEmpty(url)) {
            if (redisUtil.get(Constants.SITE_NAME_KEY + url) != null) {
                typeNum = (String) redisUtil.get(Constants.SITE_NAME_KEY + url);
            } else {
                typeNum = "12";
            }
        } else {
            typeNum = "12";
        }
        data.setInfoSourceType(typeNum);
    }

    private List<Label> getInfoSourceLabel(String origin, String sourceAddress) {
        List<String> sidList = new ArrayList<>();
        if (StringUtils.isNotEmpty(origin)) {
            LambdaQueryWrapper<InfoSource> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(InfoSource::getSiteName, origin);
            List<InfoSource> list = infoSourceService.list(queryWrapper);
            InfoSource infoSource = null;
            if (CollectionUtils.isNotEmpty(list)) {
                infoSource = list.get(0);
            }
            if (infoSource != null) {
                String sid = infoSource.getId();
                sidList.add(sid);
            } else {
                if (StringUtils.isNotEmpty(sourceAddress)) {
                    String url = Utility.domainURL(sourceAddress);
                    if (StringUtils.isNotEmpty(url)) {
                        LambdaQueryWrapper<InfoSource> query = Wrappers.lambdaQuery();
                        query.like(InfoSource::getSiteUri, url);
                        List<InfoSource> sourceList = infoSourceService.list(query);
                        if (CollectionUtils.isNotEmpty(sourceList)) {
                            sidList = sourceList.stream().map(InfoSource::getId).collect(Collectors.toList());
                        }
                    }
                }
            }
        }
        List<Label> labels = new ArrayList<>();
        List<LabelItemMapVO> clbLabelItems = commonService.infoSourceLabelsBySidList(sidList);
        Label label = new Label();
        if (CollectionUtils.isNotEmpty(clbLabelItems)) {
            LabelItemMapVO clbLabelItem = clbLabelItems.get(0);
            label.setSourceId(clbLabelItem.getEntityCode());
            label.setLabelMark(clbLabelItem.getLabelCode());
            label.setRelationId(clbLabelItem.getLabelCode() + "-" + clbLabelItem.getLabelItemCode());
        } else {//默认其他
            label.setLabelMark("LABEL-20250102-0006");
            label.setRelationId("LABEL-20250102-0006-LV-20250102-0026");
        }
        labels.add(label);
        return labels;
    }
}
