package com.zzsn.event.vo;

import com.zzsn.event.vo.es.Label;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 数据
 */
@Data
public class EventDataVO {
    //说明：...Raw 表示原文，即原语言
    //作者
    private String author;
    private String authorRaw;
    //正文
    private String content;
    private String contentRaw;
    //带标签正文
    private String contentWithTag;
    private String contentWithTagRaw;
    //入库时间
    private String createDate;
    private Date createDateTime;
    //信息id
    private String id;
    //信息来源id(信息源或者关键词)
    private String sid;
    //语言
    private String lang;
    private String langRaw;
    //来源（信息来源）
    private String origin;
    private String originRaw;
    //发布时间
    private String publishDate;
    //原始时间（网页上，没有解析之前的时间）
    private String originalTime;
    //发布地址
    private String sourceAddress;
    //摘要
    private String summary;
    private String summaryRaw;
    //关键词
    private String keyWords;
    //标题
    private String title;
    private String titleRaw;
    //采集来源（如通用、定制、微信公众号等）
    private String source;
    //附加字段
    private String type;
    //标签信息
    private List<Label> labels;
    //视频下载链接
    private String downLoadUrl;
    //视频链接（原链接 网页版）
    private String videoUrl;
    //视频链接（原链接 手机版）
    private String videoPhoneUrl;
    //视频时长
    private Long videoTime;
    //视频第一帧图片
    private String videoImg;
    //重复id
    private String repeatId;
    //（1：主条目  0：非主条目）
    private String flag;
    //关联的主条目id
    private String masterEntryId;
    //原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系)
    private String originalId;
    private String subjectId;
    //快照地址
    private String screenShotImg;
    //数据所在的索引名称
    private String index;
}
