package com.zzsn.event.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.zzsn.event.entity.InfoSourceMain;
import com.zzsn.event.entity.SysDictItem;
import com.zzsn.event.enums.BindTypeEnum;
import com.zzsn.event.feign.api.RemoteSystemService;
import com.zzsn.event.mapper.InfoSourceMainMapper;
import com.zzsn.event.service.InfoSourceMainGroupService;
import com.zzsn.event.service.InfoSourceMainService;
import com.zzsn.event.vo.InfoSourceMainGroupPage;
import com.zzsn.event.vo.InfoSourceVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 * 信息源表 服务实现类
 * </p>
 *
 * @author obcy
 * @since 2025-06-19
 */
@Service
@Slf4j
public class InfoSourceMainServiceImpl extends ServiceImpl<InfoSourceMainMapper, InfoSourceMain> implements InfoSourceMainService {

    @Autowired
    private InfoSourceMainGroupService infoSourceMainGroupService;
    @Autowired
    private RemoteSystemService remoteSystemService;
    @Override
    public IPage<InfoSourceMain> subjectBindList(InfoSourceMain infoSourceMain, String subjectId, Integer pageNo, Integer pageSize) {
        Page<InfoSourceMain> page = new Page<>(pageNo, pageSize);
        IPage<InfoSourceMain> pageList = baseMapper.subjectBindIdPageList(page, infoSourceMain,subjectId);
        if(pageList!=null && CollectionUtils.isNotEmpty(pageList.getRecords())) {
            List<InfoSourceMain> infoSourceMains = baseMapper.bindGroupSourceIdList(subjectId,pageList.getRecords().stream().map(InfoSourceMain::getId).collect(Collectors.toList()));
            Map<String, InfoSourceMain> collect1 = infoSourceMains.stream().collect(Collectors.toMap(InfoSourceMain::getId, Function.identity(), (exist, replace) -> exist));
            for (InfoSourceMain infoSourceMain1 : pageList.getRecords()){
                if (ObjectUtil.isEmpty(infoSourceMain1.getIsFreeCheck())){
                    InfoSourceMain infoSourceVo2 = collect1.get(infoSourceMain1.getId());
                    if (infoSourceVo2 != null) {
                        infoSourceMain1.setIsFreeCheck(infoSourceVo2.getIsFreeCheck());
                    }
                }
                if (ObjectUtil.isEmpty(infoSourceMain1.getIsExemptKeyword())){
                    InfoSourceMain infoSourceVo2 = collect1.get(infoSourceMain1.getId());
                    if (infoSourceVo2 != null) {
                        infoSourceMain1.setIsExemptKeyword(infoSourceVo2.getIsExemptKeyword());
                    }
                }
            }
        }
        return pageList;
    }

    @Override
    public JSONObject bindInfoSourceMainGroupList(String subjectId) {


        List<InfoSourceMainGroupPage> infoSourceGroupPages = infoSourceMainGroupService.bindInfoSourceMainGroupList(subjectId, BindTypeEnum.getInfoSourceMainGroupType());
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtil.isEmpty(infoSourceGroupPages)) {
            return jsonObject;
        }

        Map<Integer, List<InfoSourceMainGroupPage>> collect = infoSourceGroupPages.stream().collect(Collectors.groupingBy(InfoSourceMainGroupPage::getSourceType));

        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                //合并相同信息源组
                List<InfoSourceMainGroupPage> list = new ArrayList<>();
                for (InfoSourceMainGroupPage groupPage : v) {
                    Optional<InfoSourceMainGroupPage> first = list.stream().filter(f -> StrUtil.equals(f.getId(), groupPage.getId())).findFirst();
                    if(first.isPresent()){
                        InfoSourceMainGroupPage infoSourceGroupPage = first.get();
                        infoSourceGroupPage.setGroupTypeNames(infoSourceGroupPage.getGroupTypeNames()+"、"+groupPage.getGroupTypeNames());
                    }else {
                        list.add(groupPage);
                    }
                }
                jsonObject.put(enumByValue.toString(), list);
            }
        });

        return jsonObject;
    }

    @Override
    public JSONObject bindInfoSourceMainList(String subjectId) {


        List<InfoSourceMain> infoSourceVos = infoSourceMainGroupService.bindInfoSourceMainList(subjectId,BindTypeEnum.getInfoSourceMainType());
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtil.isEmpty(infoSourceVos)) {
            return jsonObject;
        }


        Map<Integer, List<InfoSourceMain>> collect = infoSourceVos.stream().collect(Collectors.groupingBy(InfoSourceMain::getSourceType));

        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                jsonObject.put(enumByValue.toString(), v);
            }
        });

        return jsonObject;
    }

    @Override
    public JSONObject bindInfoSourceMainLabelList(String subjectId) {

        List<InfoSourceMainGroupPage> infoSourceGroupPages = infoSourceMainGroupService.bindInfoSourceMainLabelList(subjectId,BindTypeEnum.getInfoSourceMainLabelType());
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtil.isEmpty(infoSourceGroupPages)) {
            return jsonObject;
        }
        //字典类的标签处理层级关系
        List<String> dictCodes = infoSourceGroupPages.stream().filter(f -> "3".equals(f.getBusinessCaliber())).map(InfoSourceMainGroupPage::getDictCode).collect(Collectors.toList());
        dictCodes.forEach(e -> {
            List<SysDictItem> dictList = getDictList(e);
            infoSourceGroupPages.forEach(ee -> {
                if (!StringUtils.isEmpty(ee.getWeight()) && "0".equals(ee.getWeight())) {
                    ee.setWeight(null);
                }
                if ("3".equals(ee.getBusinessCaliber())){
                    //标签使用的字典
                    Optional<SysDictItem> first = dictList.stream().filter(f -> f.getItemValue().equals(ee.getLabelItemCode())).findFirst();
                    if (first.isPresent()) {
                        SysDictItem dictItem = first.get();
                        if (StrUtil.isNotBlank(dictItem.getNames())) {
                            ee.setLabelItemName(dictItem.getNames());
                        }else{
                            ee.setLabelItemName(dictItem.getItemText());
                        }
                    }
                }
            });
        });

        Map<Integer, List<InfoSourceMainGroupPage>> collect = infoSourceGroupPages.stream().collect(Collectors.groupingBy(InfoSourceMainGroupPage::getSourceType));

        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                jsonObject.put(enumByValue.toString(), v);
            }
        });
        return jsonObject;
    }
    private List<SysDictItem> getDictList(String dictCode){
        Object dictList = remoteSystemService.getDictList(dictCode);
        return JSONUtil.toList(JSONUtil.parseArray(dictList), SysDictItem.class);
    }
}
