package com.zzsn.event.config;

import com.obs.services.ObsClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Description: 华为云obs配置
 * Author: EDY
 * Date: 2023/10/9
 */
@Configuration
public class ObsConfig {

    @Value("${obs.endPoint}")
    String endPoint;
    @Value("${obs.ak}")
    private String ak;
    @Value("${obs.sk}")
    private String sk;

    @Bean
    public ObsClient obsClient (){
        // 创建ObsClient实例
        return new ObsClient(ak, sk, endPoint);
    }
}
