package com.zzsn.event.controller;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.SysLoginModel;
import com.zzsn.event.service.EventLoginService;
import com.zzsn.event.util.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 研究中心嵌入的事件分析需要登录，这里是登录接口
 * @author wangFeng
 * @date 2024/10/22 11:59
 */
@RestController
public class EventLoginController {
    @Resource
    private EventLoginService eventLoginService;

    /**
     * 事件分析登录接口
     * @param sysLoginModel
     */
    @PostMapping("/loginBS")
    public Result<?> loginBS(@RequestBody SysLoginModel sysLoginModel) {
        return eventLoginService.loginBS(sysLoginModel);
    }
}
