package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.entity.LabelEntity;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.LabelTypeVO;
import com.zzsn.event.vo.SysLabelVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author lenovo
* @description 针对表【label_entity】的数据库操作Mapper
* @createDate 2023-08-28 15:02:50
* @Entity com.zzsn.clb.scheduletask.entity.LabelEntity
*/
@Mapper
public interface LabelEntityMapper extends BaseMapper<LabelEntity> {



    /**
     * 根据分类获取标签列表
     *
     * @param labelTypeId 标签分类id
     * @author lkg
     * @date 2024/1/22
     */
    List<LabelEntity> listByType(@Param("labelTypeId") String labelTypeId);

    /**
     * 国内地域信息列表
     *
     * @param level 级别
     * @author lkg
     * @date 2024/12/23
     */
    List<LabelTypeVO> regionInList(@Param("level") Integer level);
    /**
     * 国际地域信息列表
     *
     * @author lkg
     * @date 2024/4/9
     */
    List<LabelTypeVO> regionOutList();

    /**
     * 国标行业信息列表
     *
     * @author lkg
     * @date 2024/12/27
     */
    List<LabelTypeVO> industryList();

    /**
     * 企业类标签下的标签实体分页列表
     *
     * @param labelIds 标签id集合
     * @param name 实体名称
     * @author lkg
     * @date 2024/12/27
     */
    Page<SysLabelVo> queryCustomLabel(@Param("labelIdList") List<String> labelIds,@Param("name") String name,Page<SysLabelVo> page);

    /**
     * 企业类标签下的标签实体(企业)分页列表
     *
     * @param labelIds 标签id集合
     * @param name 实体(企业)名称
     * @author lkg
     * @date 2024/12/27
     */
    Page<SysLabelVo> queryCompanyLabel(@Param("labelIdList") List<String> labelIds,@Param("name") String name,Page<SysLabelVo> page);
    /**
     * 企业类标签下的标签实体(人物)分页列表
     *
     * @param labelIds 标签id集合
     * @param name 实体(人物)名称
     * @author lkg
     * @date 2024/12/27
     */
    Page<SysLabelVo> queryGovernmentLeaders(@Param("labelIdList") List<String> labelIds,@Param("name") String name,Page<SysLabelVo> page);



}




