package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 事件大模型信息配置表
* @TableName event_llm_config
*/
@Data
@TableName("event_llm_config")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EventLlmConfig implements Serializable {

    /**
    * 主键id
    */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 事件id
    */
    private String eventId;
    /**
    * 栏目编码
    */
    private Integer columnCode;
    /**
    * 栏目名称
    */
    private String columnName;
    /**
    * 大模型
    */
    private String llmName;
    /**
    * 角色
    */
    private String llmRole;
    /**
    * 提示词
    */
    private String llmPrompt;
    /**
    * 资讯筛选条件
    */
    private String articleCondition;
    /**
    * 状态(1-启用;0-禁用)
    */
    private Integer status;
    /**
    * 是否默认(1-是;0-否)
    */
    private Integer ynDefault;
    /**
    * 排序号
    */
    private Integer sortNum;
    /**
    * 创建人
    */
    private String createBy;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
    * 更新人
    */
    private String updateBy;
    /**
    * 更新时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
