package com.zzsn.event.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.zzsn.event.es.EsService;
import com.zzsn.event.mapper.InfoSourceMapper;
import com.zzsn.event.service.IInfoSourceService;
import com.zzsn.event.vo.CountVO;
import com.zzsn.event.vo.InfoSourceCondition;
import com.zzsn.event.vo.InfoSourceVo;
import com.zzsn.event.vo.NumVO;
import com.zzsn.event.xxljob.entity.InfoSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date:   2022-01-18
 * @Version: V1.0
 */
@Service
public class InfoSourceServiceImpl extends ServiceImpl<InfoSourceMapper, InfoSource> implements IInfoSourceService {

    @Autowired
    private EsService esService;

    @Override
    public IPage<InfoSourceVo> bindInfoSourceList(InfoSourceCondition infoSourceCondition, List<String> subjectIds, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        if (pageNo == 0) {
            offset = 0;
        }
        List<InfoSourceVo> pageList = new ArrayList<>();
        List<String> bindList = baseMapper.bindSourceIdList(infoSourceCondition,subjectIds,offset,pageSize);
        if (CollectionUtils.isNotEmpty(bindList)) {
            pageList = baseMapper.queryInfoSource(bindList);
            for (InfoSourceVo infoSourceVo1 : pageList) {
                //性质
                if (StringUtils.isNotEmpty(infoSourceVo1.getNatureIds())) {
                    String natureIds = infoSourceVo1.getNatureIds();
                    List<String> natureIdList = Arrays.asList(natureIds.split(","));
                    infoSourceVo1.setInfoSourceNatureIds(natureIdList);
                }
                //采集量
                NumVO totalCollectCount = esService.count(infoSourceVo1.getId(), null, null, 1);
                //总采集量
                infoSourceVo1.setTotalCount(totalCollectCount.getCount());
                Date endTime = new Date();
                DateTime startTime = DateUtil.offsetDay(endTime, -30);
                //月采集量
                NumVO monthCollectCount = esService.count(infoSourceVo1.getId(), DateUtil.formatDate(startTime), DateUtil.formatDate(endTime), 2);
                infoSourceVo1.setMonthCount(monthCollectCount.getCount());

                List<NumVO> children = monthCollectCount.getChildren();
                Map<String, List<NumVO>> collect = children.stream().collect(Collectors.groupingBy(NumVO::getKey));
                //周采集量
                long weekCount = 0L;
                List<DateTime> rangeToList = DateUtil.rangeToList(DateUtil.offsetDay(endTime, -7), endTime, DateField.DAY_OF_YEAR);
                for (DateTime dateTime : rangeToList) {
                    List<NumVO> countVOS = collect.get(DateUtil.formatDate(dateTime));
                    if (CollectionUtils.isNotEmpty(countVOS)) {
                        weekCount += countVOS.get(0).getCount();
                    }
                }
                infoSourceVo1.setWeekCount(weekCount);
                //昨日采集量
                DateTime yesterday = DateUtil.yesterday();
                List<NumVO> countVOS = collect.get(DateUtil.formatDate(yesterday));
                if (CollectionUtils.isNotEmpty(countVOS)) {
                    infoSourceVo1.setYesterdayCount(countVOS.get(0).getCount());
                } else {
                    infoSourceVo1.setYesterdayCount(0L);
                }
            }
        }
        Long count = baseMapper.bindSourceIdCount(infoSourceCondition, subjectIds);
        IPage<InfoSourceVo> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }

    @Override
    public IPage<InfoSourceVo> unBindSourcePageList(InfoSourceCondition infoSourceCondition, String subjectId, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        List<InfoSourceVo> pageList = baseMapper.unBindSourcePageList(infoSourceCondition, subjectId, offset, pageSize);
        Long count = baseMapper.unBindSourceCount(infoSourceCondition, subjectId);
        IPage<InfoSourceVo> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }
}
