package com.zzsn.event.permit;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
public class SqlConditionUtil {
    private static String FLAG_AND = "and";
    private static String FLAG_OR = "or";
    public static List<String> FLAG_LIST;

    final static String[] MUST_CONDTION_FIELDS = new String[]{"name", "value", "condition"};

    static {
        FLAG_LIST = new ArrayList<>();
        FLAG_LIST.add("and");
        FLAG_LIST.add("or");


    }

    public static String getSql(JSONObject jo) {
        StringBuilder stringBuilder = new StringBuilder();
        setChd(jo, stringBuilder);
        return stringBuilder.toString();
    }


    private static void setChd(JSONObject jo, StringBuilder stringBuilder) {
        stringBuilder.append("(");
        for (int i = 0; i < jo.getJSONArray("query").size(); i++) {
            JSONObject chdJo = (JSONObject) jo.getJSONArray("query").get(i);
            if (chdJo.containsKey("flag") && FLAG_LIST.contains(jo.getString("flag").toLowerCase())) {
                setChd(chdJo, stringBuilder);
            } else {
                setCondition(stringBuilder, chdJo);
            }
            if (i < jo.getJSONArray("query").size() - 1) {
                setFlag(stringBuilder, jo.getString("flag").toLowerCase());
            }
        }
        stringBuilder.append(")");
    }

    private static void setFlag(StringBuilder stringBuilder, String flag) {
        stringBuilder.append(" ");
        stringBuilder.append(flag);
        stringBuilder.append(" ");
    }

    /***
     * 装配查询条件
     * @param stringBuilder
     * @param jsonObject
     */
    private static void setCondition(StringBuilder stringBuilder, JSONObject jsonObject) {
        if (jsonObject.containsKey("condition") && "isNull".equals(jsonObject.getString("condition"))) {
            stringBuilder.append(jsonObject.getString("name"));
            stringBuilder.append(" is null ");
            return;
        }
        for (String field : MUST_CONDTION_FIELDS) {
            if (!jsonObject.containsKey(field) || StringUtils.isBlank(jsonObject.getString(field))) {
                return;
            }
        }
        try {
            String condtion = jsonObject.getString("condition");
            if (!Constant.symbolMap.containsKey(condtion)) {
                return;
            }
            String name = jsonObject.getString("name");
            Object value = jsonObject.get("value");
            boolean isNumber = false;

            if (jsonObject.containsKey("dataType") && "number".equals(jsonObject.getString("dataType"))) {
                isNumber = true;
            }
            switch (condtion) {
                case "like": {
                    value = "'%" + jsonObject.get("value").toString() + "%'";
                    break;
                }
                case "likeLeft": {
                    value = "'%" + jsonObject.get("value").toString();
                    break;
                }
                case "likeRight": {
                    value = jsonObject.get("value").toString() + "%'";
                    break;
                }
                case "in": {
                    //数字类型
                    if (isNumber) {
                        value = jsonObject.getJSONArray("value").toJSONString().replaceAll("\",\"", ",").replace("[\"", "(").replace("\"]", ")").replace("[", "(").replace("]", ")");
                    } else {
                        value = jsonObject.getJSONArray("value").toJSONString().replaceAll("\",\"", "','").replace("[\"", "('").replace("\"]", "')");
                    }
                    break;
                }
                default:
                    value = isNumber == true ? value : "'" + value + "'";
                    break;
            }
            stringBuilder.append(name);
            stringBuilder.append(" ");
            stringBuilder.append(Constant.symbolMap.get(condtion));
            stringBuilder.append(" ");
            stringBuilder.append(value);

        } catch (
                Exception ex) {
            log.error("{}", ex);
        }
    }

    public static String get(JSONObject jo) {
        String sql = getSql(jo);
        if ("()".equals(sql)) {
            return null;
        } else {
            return sql;
        }
    }

    public static void main(String[] ag) {

        log.info(JSON.toJSONString(getSql(getData())));
    }

    public static JSONObject getData() {
        try {
            //data-数据授权-人物类.json
            InputStream inputStream = new ClassPathResource("1.json").getInputStream();
            String text = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            inputStream.close();
            return JSON.parseObject(text);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

}
