package com.zzsn.event.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.ScoreModel;
import com.zzsn.event.mapper.ScoreModelMapper;
import com.zzsn.event.service.CommonService;
import com.zzsn.event.service.ISubjectInfoSourceMapService;
import com.zzsn.event.service.ScoreModelService;
import com.zzsn.event.util.HttpUtil;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.ScoreModelVo;
import com.zzsn.event.vo.SubjectScoreModel;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 打分模型
 * @Author: jeecg-boot
 * @Date:   2021-12-17
 * @Version: V1.0
 */
@Service
public class ScoreModelServiceImpl extends ServiceImpl<ScoreModelMapper, ScoreModel> implements ScoreModelService {

    @Autowired
    private CommonService commonService;
    @Autowired
    private ISubjectInfoSourceMapService subjectInfoSourceMapService;

    @Value("${python.scoreModelUrl}")
    private String scoreModelUrl;

    @Override
    public void addOrUpdate(ScoreModelVo scoreModel,Integer category) {
        LambdaQueryWrapper<ScoreModel> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ScoreModel::getSubjectId,scoreModel.getSubjectId())
                        .eq(ScoreModel::getType,scoreModel.getType());
        baseMapper.delete(queryWrapper);
        ScoreModel scoreModelNew = new ScoreModel();
        BeanUtils.copyProperties(scoreModel, scoreModelNew);
        baseMapper.insert(scoreModelNew);
        if (scoreModel.getChangeType() == 1) {
            JSONObject jsonObject = commonService.siteInfo(scoreModel.getSubjectId(), scoreModel.getType(),category);
            //调用python接口
            try {
                HttpUtil.doPost(scoreModelUrl, jsonObject, 3000);
            } catch (IOException e) {
                log.error("传递专题配置信息异常!");
            }
        }
    }

    @Override
    public List<ScoreModelVo> queryScoreModel(String subjectId, String type){
        return baseMapper.selectByInfo(subjectId, type);
    }

    @Override
    public JSONObject scoreModelInfo(String subjectId, String type) {
        //先查询数据库是否存在数据
        JSONObject jsonObject = new JSONObject();
        List<ScoreModelVo> list = baseMapper.selectByInfo(subjectId, type);
        if(CollectionUtils.isNotEmpty(list)){
            //不为空，则查询数据库存在的信息
            Object data = list.get(0).getData();
            jsonObject.put("data", data);
            return jsonObject;
        }else{
            //为空，返回默认值
            return defaultInfo(subjectId,type);
        }
    }


    private JSONObject defaultInfo(String subjectId,String type){
        JSONObject jsonObject = new JSONObject();
        List<SubjectScoreModel> allList = new ArrayList<>();
        SubjectScoreModel subjectScoreModel = new SubjectScoreModel();
        subjectScoreModel.setName("信息源组");
        subjectScoreModel.setIndexWeight((double)10);
        //1.查出绑定的信息源
        JSONObject infoSourceGroupPages = subjectInfoSourceMapService.bindInfoSource(subjectId);
        JSONArray bindList = infoSourceGroupPages.getJSONArray("bindList");
        List<InfoSourceGroupPage>  infoSourceGroupList = JSONArray.parseArray(bindList.toJSONString(), InfoSourceGroupPage.class);
        List<SubjectScoreModel> childrenList = new ArrayList<>();
        for(InfoSourceGroupPage infoSourceGroupPage : infoSourceGroupList){
            SubjectScoreModel subjectScoreModel1 = new SubjectScoreModel();
            subjectScoreModel1.setInfoSourceGroupId(infoSourceGroupPage.getId());
            subjectScoreModel1.setId(infoSourceGroupPage.getId());
            subjectScoreModel1.setName(infoSourceGroupPage.getGroupName());
            subjectScoreModel1.setFraction(80);
            childrenList.add(subjectScoreModel1);
        }
        subjectScoreModel.setChildren(childrenList);
        allList.add(subjectScoreModel);

        //2.文章长度
        SubjectScoreModel subjectScoreModel2 = new SubjectScoreModel();
        subjectScoreModel2.setName("文章长度");
        if ("1".equals(type) || "2".equals(type) || "4".equals(type) || "5".equals(type)) {
            subjectScoreModel2.setIndexWeight((double) 15);
        } else if ("3".equals(type)) {
            subjectScoreModel2.setIndexWeight((double)10);
        }
        subjectScoreModel2.setKeyWordsLowerLimit(500);
        subjectScoreModel2.setKeyWordsTopLimit(2500);
        allList.add(subjectScoreModel2);
        //3.内容
        SubjectScoreModel subjectScoreModel3 = new SubjectScoreModel();

        subjectScoreModel3.setName("内容");
        List<SubjectScoreModel> contentChildrenList = new ArrayList<>();
        SubjectScoreModel subjectScoreModel1 = new SubjectScoreModel();
        SubjectScoreModel subjectScoreModel4 = new SubjectScoreModel();
        if ("1".equals(type) || "2".equals(type) || "4".equals(type) || "5".equals(type)) {
            subjectScoreModel1.setName("内容-关键词");
            subjectScoreModel1.setIndexWeight((double)75);
            subjectScoreModel1.setTitleWeight((double)10);
            subjectScoreModel1.setKeyWordsLowerLimit(3);
            subjectScoreModel1.setKeyWordsTopLimit(15);
            contentChildrenList.add(subjectScoreModel1);
        }  else if ("3".equals(type)) {
            subjectScoreModel1.setName("内容-关键词");
            subjectScoreModel1.setIndexWeight((double)10);
            subjectScoreModel1.setTitleWeight((double)10);
            subjectScoreModel1.setKeyWordsLowerLimit(3);
            subjectScoreModel1.setKeyWordsTopLimit(15);
            subjectScoreModel1.setKeyWords("现状|基本情况|做法|经验|特征|特点|成效|成果|趋势|机遇|挑战|问题|难点|难题|不足|建议");
            contentChildrenList.add(subjectScoreModel1);

            subjectScoreModel4.setName("内容-关键词");
            subjectScoreModel4.setIndexWeight((double)70);
            subjectScoreModel4.setTitleWeight((double)10);
            subjectScoreModel4.setKeyWordsLowerLimit(3);
            subjectScoreModel4.setKeyWordsTopLimit(15);
            contentChildrenList.add(subjectScoreModel4);
        }
        subjectScoreModel3.setChildren(contentChildrenList);
        allList.add(subjectScoreModel3);
        JSONArray array= JSONArray.parseArray(JSON.toJSONString(allList));
        jsonObject.put("data",array);
        return jsonObject;
    }
}
