package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.SubjectCondition;
import com.zzsn.event.vo.SubjectPage;
import com.zzsn.event.vo.SubjectDetailVO;
import com.zzsn.event.vo.SubjectPageVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题表
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
@Mapper
public interface SubjectMapper extends BaseMapper<Subject> {

    /**
     * 专题分页列表
     *
     * @param subjectCondition 查询条件
     * @param page             分页参数
     * @author lkg
     * @date 2024/12/18
     */
    Page<SubjectPage> pageList(@Param("subjectCondition") SubjectCondition subjectCondition, Page<SubjectPage> page);

    /**
     *专题分页列表-新
     *
     * @param subjectCondition 查询条件
     * @param page 分页参数
     * @author lkg
     * @date 2025/3/25
     */
    Page<SubjectPageVO> pageList_new(Page<SubjectPageVO> page,@Param("subjectCondition") SubjectCondition subjectCondition,@Param("userId") String userId);

    /**
     * 专题详情(包含专题分类、专题项目)
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/3/25
     */
    SubjectPage getInfo(@Param("subjectId") String subjectId);
    /**
     * 专题分页列表（个人）-研究中心
     *
     * @param subjectCondition 查询条件
     * @param page             分页参数
     * @author lkg
     * @date 2024/12/18
     */
    Page<SubjectPage> researchCenterPageList(@Param("subjectCondition") SubjectCondition subjectCondition, Page<SubjectPage> page);

    /**
     * 专题分页列表（公开）-研究中心
     *
     * @param subjectCondition 查询条件
     * @param page             分页参数
     * @author lkg
     * @date 2025/1/14
     */
    Page<SubjectPage> researchCenterFacePageList(@Param("subjectCondition") SubjectCondition subjectCondition, Page<SubjectPage> page,@Param("sql") String sql,@Param("username") String username);

    /**
     * 当前用户可见的专题分页列表（公开和个人非公开）-研究中心
     *
     * @param username    用户名称
     * @param type        分类(1-个人;2-公开;3-个人+公开)
     * @param subjectName 专题名称
     * @param page        分页参数
     * @author lkg
     * @date 2025/2/8
     */
    Page<Node> visibleList(@Param("username") String username, @Param("type") Integer type, @Param("subjectName") String subjectName, Page<String> page,@Param("environment") String environment,@Param("sql") String sql);

    /**
     * 获取专题详情(包含样例文章信息)
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/8
     */
    SubjectDetailVO queryInfo(@Param("subjectId") String subjectId);

    /**
     * 专题详情
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/12/18
     */
    SubjectPage selectSubjectById(@Param("subjectId") String subjectId);

    /**
     * 判断信息源是否在专题绑定的信息源组下
     *
     * @param subjectId 专题id
     * @param sourceId  信息源id
     * @author lkg
     * @date 2024/4/24
     */
    int ynBelowBindGroup(@Param("subjectId") String subjectId, @Param("sourceId") String sourceId);

    /**
     * 判断信息源是否在专题排除的信息源组下
     *
     * @param subjectId 专题id
     * @param sourceId  信息源id
     * @author lkg
     * @date 2024/4/24
     */
    int ynBelowExcludeGroup(@Param("subjectId") String subjectId, @Param("sourceId") String sourceId);

    List<String> getBindSubjectIds(@Param("id")String id);

    String getMinCreateTime(@Param("subjectIdList") List<String> subjectIdList);
}
