package com.zzsn.event.service;


import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.vo.CoOccurrenceVO;
import com.zzsn.event.vo.CountVO;
import com.zzsn.event.vo.EventContextVO;
import com.zzsn.event.vo.PropagationPathVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lkg
 * @description: 专题分析
 * @date 2022/7/20 11:25
 */
public interface AnalysisService {

    /**
     * 事件脉络
     *
     * @param eventId 专题id
     * @param fakeNum 专题事件脉络展示 伪事件脉络 的资讯数量阈值
     * @return java.util.List<com.zzsn.subjectAnalysis.entity.SubjectAnalysis>
     */
    List<SubjectAnalysis> eventContext(String eventId, int fakeNum);

    /**
     * 事件脉络-新版
     *
     * @param eventId 专题id
     * @author lkg
     * @date 2025/7/7
     */
    List<JSONObject> eventContext(String eventId);

    /**
     * 词云
     *
     * @param eventId 专题id
     * @param size    返回热词个数
     * @author lkg
     * @date 2025/7/7
     */
    List<CountVO> wordCloud(String eventId, Integer size);

    /**
     * 关键词时间趋势
     *
     * @param eventId 事件id
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/9
     */
    List<CountVO> wordTrend(String eventId, String endTime);

    /**
     * 关键词共现
     *
     * @param eventId 事件id
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/9
     */
    List<CoOccurrenceVO> coOccurrence(String eventId, String endTime);

    /**
     * 传播路径
     *
     * @param eventId 专题id
     * @return com.zzsn.subjectAnalysis.vo.PropagationPathVo
     */
    PropagationPathVo propagationPath(String eventId);
}
