package com.zzsn.event.feign.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

//feign调用
@FeignClient(value = "service-model")
public interface RemoteModelService {

    /**
     * 重新打分请求
     *
     * @param subjectId 专题id
     * @param flowId TPU流程id
     * @author lkg
     * @date 2025/2/7
     */
    @GetMapping("/modelArrange/clbBiz/detailSubjectDataWithFlow")
    String reScoreRequest(@RequestParam("subjectId") String subjectId,@RequestParam("flowId") String flowId, @RequestHeader HttpHeaders headers);

    /**
     * 重新打分请求
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/2/7
     */
    @GetMapping("/modelArrange/clbBiz/delMiddelDataBySubjectId")
    String removeMiddleDataRequest(@RequestParam("subjectId") String subjectId);


    /**
     * 清除专题缓存
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/2/7
     */
    @GetMapping("/modelArrange/clbModelMonitor/delSubjectCache")
    String delSubjectCache(@RequestParam("subjectId") String subjectId);


}
