package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.ClbLabel;
import com.zzsn.event.vo.InfoSourceLabelVO;
import com.zzsn.event.vo.LabelDictItemVO;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author obcy
 * @since 2024-08-23
 */
public interface ClbLabelService extends IService<ClbLabel> {

    /**
     * 专题绑定的信息源标签信息
     *
     * @param subjectId 专题
     * @author lkg
     * @date 2025/1/2
     */
    List<InfoSourceLabelVO> bindInfoSourceLabelInfo(String subjectId);

    /**
     * 获取分类下的标签信息
     *
     * @param labelTypeId 标签分类id
     * @author lkg
     * @date 2025/1/2
     */
    List<InfoSourceLabelVO> labelInfoByType(String labelTypeId);

    List<String> subjectBindMainLabelList(String subjectId);
    List<LabelDictItemVO> subjectBindMainLabels(String subjectId);
}
