package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.EventLlmConfig;
import com.zzsn.event.service.EventLlmConfigService;
import com.zzsn.event.mapper.EventLlmConfigMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author lenovo
* @description 针对表【event_llm_config(事件大模型信息配置表)】的数据库操作Service实现
* @createDate 2025-07-21 14:17:40
*/
@Service
public class EventLlmConfigServiceImpl extends ServiceImpl<EventLlmConfigMapper, EventLlmConfig> implements EventLlmConfigService{

    @Override
    public List<EventLlmConfig> getConfigList(String eventId) {
        LambdaQueryWrapper<EventLlmConfig> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventLlmConfig::getEventId, eventId).orderByAsc(EventLlmConfig::getColumnCode);
        List<EventLlmConfig> configList = this.list(queryWrapper);
        if (CollectionUtils.isEmpty(configList)) {
            LambdaQueryWrapper<EventLlmConfig> query = Wrappers.lambdaQuery();
            query.eq(EventLlmConfig::getYnDefault, 1).orderByAsc(EventLlmConfig::getColumnCode);
            configList = this.list(query);
        }
        return configList;
    }

    @Override
    public EventLlmConfig getConfig(String eventId, Integer columnCode) {
        LambdaQueryWrapper<EventLlmConfig> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventLlmConfig::getEventId, eventId).eq(EventLlmConfig::getColumnCode, columnCode);
        EventLlmConfig config = this.getOne(queryWrapper);
        if (ObjectUtils.isNull(config)) {
            LambdaQueryWrapper<EventLlmConfig> query = Wrappers.lambdaQuery();
            query.eq(EventLlmConfig::getYnDefault, 1).eq(EventLlmConfig::getColumnCode, columnCode);
            config = this.getOne(query);
        }
        return config;
    }

    @Override
    @Transactional
    public void modifyBatch(List<EventLlmConfig> eventLlmConfigList) {
        if (CollectionUtils.isEmpty(eventLlmConfigList)) {
            return;
        }
        String eventId = eventLlmConfigList.get(0).getEventId();
        LambdaQueryWrapper<EventLlmConfig> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventLlmConfig::getEventId, eventId);
        List<EventLlmConfig> configList = this.list(queryWrapper);
        if (CollectionUtils.isEmpty(configList)) {
            List<Integer> configCodeList = eventLlmConfigList.stream().map(EventLlmConfig::getColumnCode).collect(Collectors.toList());
            LambdaQueryWrapper<EventLlmConfig> query = Wrappers.lambdaQuery();
            query.eq(EventLlmConfig::getYnDefault, 1).orderByAsc(EventLlmConfig::getColumnCode);
            List<EventLlmConfig> defaultConfigList = this.list(query);
            if (defaultConfigList.size() > eventLlmConfigList.size()) {
                List<EventLlmConfig> collect = defaultConfigList.stream().filter(config -> !configCodeList.contains(config.getColumnCode())).collect(Collectors.toList());
                for (EventLlmConfig config : collect) {
                    config.setId(null);
                    config.setEventId(eventId);
                    config.setYnDefault(0);
                }
                eventLlmConfigList.addAll(collect);
            }
            this.saveBatch(eventLlmConfigList);
        } else {
            for (EventLlmConfig eventLlmConfig : eventLlmConfigList) {
                LambdaUpdateWrapper<EventLlmConfig> update = Wrappers.lambdaUpdate();
                update.eq(EventLlmConfig::getEventId, eventId).eq(EventLlmConfig::getColumnCode, eventLlmConfig.getColumnCode());
                this.update(eventLlmConfig,update);
            }
        }
    }

    @Override
    public void modifySingle(EventLlmConfig eventLlmConfig) {
        String eventId = eventLlmConfig.getEventId();
        LambdaQueryWrapper<EventLlmConfig> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventLlmConfig::getEventId, eventId);
        List<EventLlmConfig> configList = this.list(queryWrapper);
        if (CollectionUtils.isEmpty(configList)) {
            LambdaQueryWrapper<EventLlmConfig> query = Wrappers.lambdaQuery();
            query.eq(EventLlmConfig::getYnDefault, 1).orderByAsc(EventLlmConfig::getColumnCode);
            List<EventLlmConfig> defaultConfigList = this.list(query);
            List<EventLlmConfig> collect = defaultConfigList.stream().filter(config -> !eventLlmConfig.getColumnCode().equals(config.getColumnCode())).collect(Collectors.toList());
            for (EventLlmConfig config : collect) {
                config.setId(null);
                config.setEventId(eventId);
                config.setYnDefault(0);
            }
            eventLlmConfig.setYnDefault(0);
            collect.add(eventLlmConfig);
            collect.sort(Comparator.comparingInt(EventLlmConfig::getColumnCode));
            this.saveBatch(collect);
        } else {
            LambdaUpdateWrapper<EventLlmConfig> update = Wrappers.lambdaUpdate();
            update.eq(EventLlmConfig::getEventId, eventId).eq(EventLlmConfig::getColumnCode, eventLlmConfig.getColumnCode());
            this.update(eventLlmConfig,update);
        }
    }
}




