package com.zzsn.event.enums;

import java.util.ArrayList;
import java.util.List;

public enum SourceTypeEnum {
    BASE_DATE_TO_SUBJECT_ORI("baseDateToSubjectOri" ,"定向信息源","定向信息源"),
    BASE_DATE_TO_SUBJECT("baseDateToSubject", "通用信息源","通用信息源"),
    BASE_DATE_TO_SUBJECT_IGNORE_KW("baseDateToSubjectIgnoreKw", "通用信息源（免过关键词信息源）","通用信息源（免过关键词信息源）"),
    BASE_DATE_TO_SUBJECT_VIDEO("baseDateToSubjectVideo", "视频数据","专题绑定的所有信息源的视频数据"),
    SUBJECT_TO_SUBJECT("subjectToSubject", "专题库","专题到专题来源"),
    ENTERPRISE_TO_SUBJECT_TYPE_OTHER("enterpriseToSubjectTypeOther", "企业库-其他","企业库源研报、公告、动态数据来源"),
    ENTERPRISE_TO_SUBJECT_TYPE_YEAR("enterpriseToSubjectTypeYear", "企业库-年报","企业库年报来源"),
    POLICY_TO_SUBJECT("policyToSubject", "政策库","政策法规来源"),
    YJZX_PLATFORM_TO_SUBJECT("yjzxPlatFormToSubject", "平台数据","平台数据来源"),
    KEYWORDS_TO_SUBJECT("keyWordsToSubject", "采集词","配置的采集词组来源");

    private final String value;
    private final String description;
    private final String valueName;

    SourceTypeEnum(String value, String valueName, String description) {
        this.value = value;
        this.description = description;
        this.valueName = valueName;
    }

    public String getValue() {
        return value;
    }

    public String getDescription() {
        return description;
    }

    public String getValueName() {
        return valueName;
    }

    public static String getDescriptionByValue(String value) {
        for (SourceTypeEnum enumValue : values()) {
            if (enumValue.getValue().equals(value)) {
                return enumValue.getDescription();
            }
        }
        return null;
    }

    public static String getValueNameByValue(String value) {
        for (SourceTypeEnum enumValue : values()) {
            if (enumValue.getValue().equals(value)) {
                return enumValue.getValueName();
            }
        }
        return null;
    }

    public static List<String> getAllValues() {
        List<String> values = new ArrayList<>();
        for (SourceTypeEnum enumValue : values()) {
            values.add(enumValue.getValue());
        }
        return values;
    }
    public static List<String> getbaseDateSourceType() {
        List<String> values = new ArrayList<>();
        values.add(SourceTypeEnum.BASE_DATE_TO_SUBJECT.getValue());
        values.add(SourceTypeEnum.BASE_DATE_TO_SUBJECT_ORI.getValue());
        values.add(SourceTypeEnum.BASE_DATE_TO_SUBJECT_IGNORE_KW.getValue());
        values.add(SourceTypeEnum.BASE_DATE_TO_SUBJECT_VIDEO.getValue());
        values.add(SourceTypeEnum.KEYWORDS_TO_SUBJECT.getValue());
        return values;
    }
    public static List<String> getEnterpriseSourceType() {
        List<String> values = new ArrayList<>();
        values.add(SourceTypeEnum.ENTERPRISE_TO_SUBJECT_TYPE_OTHER.getValue());
        values.add(SourceTypeEnum.ENTERPRISE_TO_SUBJECT_TYPE_OTHER.getValue());
        return values;
    }
}
