package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @Description: 算法模型表
 * @Author: jeecg-boot
 * @Date:   2023-02-14
 * @Version: V1.0
 */
@Data
@TableName("clb_algorithm_model")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="clb_algorithm_model对象", description="算法模型表")
public class AlgorithmModel {

	/**主键id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键id")
	private String id;
	/**模型名称*/
	@Excel(name = "模型名称", width = 15)
    @ApiModelProperty(value = "模型名称")
	private String name;
	/**唯一标识*/
	@Excel(name = "唯一标识", width = 15)
    @ApiModelProperty(value = "唯一标识")
	private String uuid;

	@Excel(name = "功能类型", width = 15)
    @ApiModelProperty(value = "功能类型")
	private String functionType;

	@Excel(name = "功能文件类型，0文本，1图片，2视频，3音频", width = 15)
    @ApiModelProperty(value = "功能文件类型，0文本，1图片，2视频，3音频")
	private String functionFileType;

	/**模型分类*/
	@Excel(name = "模型分类", width = 15)
    @ApiModelProperty(value = "模型分类")
	private String type;
	/**模型结构*/
	@Excel(name = "模型结构", width = 15)
    @ApiModelProperty(value = "模型结构")
	private String structure;
	/**描述*/
	@Excel(name = "描述", width = 15)
    @ApiModelProperty(value = "描述")
	private String remark;
	/**是否可显示,默认0,可现实,1不可显示*/
	@Excel(name = "是否可显示,默认0,可现实,1不可显示", width = 15)
    @ApiModelProperty(value = "是否可显示,默认0,可现实,1不可显示")
	private Integer canShow;
	/**创建人*/
	@Excel(name = "创建人", width = 15)
    @ApiModelProperty(value = "创建人")
	private String createBy;
	/**创建时间*/
	@Excel(name = "创建时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
	private java.util.Date createTime;
	/**更新人*/
	@Excel(name = "更新人", width = 15)
    @ApiModelProperty(value = "更新人")
	private String updateBy;
	/**更新时间*/
	@Excel(name = "更新时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间")
	private java.util.Date updateTime;
	/**版本号*/
	@Excel(name = "版本号", width = 15)
    @ApiModelProperty(value = "版本号")
	private Integer versionCode;
	/**版本描述*/
	@Excel(name = "版本描述", width = 15)
    @ApiModelProperty(value = "版本描述")
	private String versionRemark;
	/**0:保留,1:删除*/
	@Excel(name = "0:保留,1:删除", width = 15)
    @ApiModelProperty(value = "0:保留,1:删除")
	private Integer status;

	private String  labelId;

	private String  serviceName;

	private String  url;

	@TableField(exist = false)
	private String projectIds;

	/*
	 * 模型所在服务器的id
	 */
	private String  serverId;
	/*
	 * 模型所在服务器的名字
	 */
	@TableField(exist = false)
	private String  serverName;

	private String modelConf;

	private String  taskName;

	/*
	 * 关联模型的id
	 */
	private String modelId;

	/*
	 * 训练版本号
	 */
	private String trainVersion;


	private String publishVersion;

	/*
	 * 任务所处的阶段
	 */
	private Integer modelStatus;

	/*
	 * 常见任务的时候，参数配置。
	 */
	private String paramterData;

	@TableField(exist=false)
	private String yuliaoId;
	@TableField(exist=false)
	private String version;

	/*
	 * 算法描述
	 */
	private String functionDesc;
	/*
	 * 算法模型服务器ip
	 */
	private String serviceIp;
	/*
	 * 算法模型服务器端口
	 */
	private Integer servicePort;
	/*
	 * 模型来源，0训练，1挂载
	 */
	private Integer modelSource;
	/*
	 * 是否是大模型1是，0否
	 */
	private Integer isLargeModel;

}
