package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.entity.EventTag;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 *
 *
 * @author lkg
 * @date 2024/4/12
 */
@Data
public class EventVO {

    /**事件id*/
    private String id;
    /**事件图标*/
    private String eventIcon;
    /**事件编码*/
    private String eventCode;
    /**事件名称*/
    private String eventName;
    /**开始时间*/
    private String startTime;
    /**jssj*/
    private String endTime;
    /**fbsj*/
    private String publishDate;
    /**事件描述*/
    private String eventDescribe;
    /**事件描述是否人工编辑(1-是;0-否)*/
    private Integer ynManualEdit;
    /**事件标签*/
    private String eventLabel;
    /**关联事件*/
    private String relationEvents;
    /**是否公开(0-未公开;1-已公开)*/
    private Integer facePublic;
    /**事件分类id*/
    private String eventType;
    /**事件分类名称*/
    private String typeName;
    /**划分专题库*/
    private String library;
    /**定时单位(1分;2小时;3日:4月)*/
    private String unit;
    /**定时数值*/
    private Integer space;
    /***cron表达式*/
    private String cron;
    /**专题分类id*/
    private String subjectTypeId;
    /**项目id*/
    private String projectId;
    /**排序号*/
    private Integer sortOrder;
    /**是否开启采集(1-是;0-否)*/
    private Integer ynCollect;
    /**第一次启用时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date firstOpenTime;


    /**是否生成分析报告*/
    private Boolean hasReport;

    /**关联事件详细信息*/
    private List<EventVO> relatedEventList;
    /**事件标签信息*/
    private EventTag eventTag;
    /**事件地域信息*/
    List<RegionVO> regionList;
    /**关键词*/
    private KeywordsVO keywordsVO;
    private String dataScope;

    /**是否关注*/
    private Boolean ynAttention;
}
