package com.zzsn.event.controller.biz;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.ClbSubjectHitwordsMap;
import com.zzsn.event.service.ClbSubjectHitwordsMapService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 流程编排 前端控制器
 * </p>
 *
 * @author obcy
 * @since 2025-04-23
 */
@RestController
@RequestMapping("/subject/hitwordsMap")
public class ClbSubjectHitwordsMapController {
    @Autowired
    private ClbSubjectHitwordsMapService clbSubjectHitwordsMapService;

    /**
     * 分页列表查询
     *
     * @param clbSubjectHitwordsMap
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @ApiOperation(value="专题命中词-分页列表查询", notes="专题命中词-分页列表查询")
    @GetMapping(value = "/pageList")
    public Result<?> queryPageList(ClbSubjectHitwordsMap clbSubjectHitwordsMap,
                                   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   HttpServletRequest req) {
        LambdaQueryWrapper<ClbSubjectHitwordsMap> queryWrapper = Wrappers.<ClbSubjectHitwordsMap>lambdaQuery();
        queryWrapper.orderByDesc(ClbSubjectHitwordsMap::getCreateTime);
        queryWrapper.eq(StrUtil.isNotBlank(clbSubjectHitwordsMap.getSubjectId()),ClbSubjectHitwordsMap::getSubjectId,clbSubjectHitwordsMap.getSubjectId());
        queryWrapper.like(StrUtil.isNotBlank(clbSubjectHitwordsMap.getWordName()),ClbSubjectHitwordsMap::getWordName,clbSubjectHitwordsMap.getWordName());
        Page<ClbSubjectHitwordsMap> page = new Page<ClbSubjectHitwordsMap>(pageNo, pageSize);
        IPage<ClbSubjectHitwordsMap> pageList = clbSubjectHitwordsMapService.page(page, queryWrapper);
        return Result.OK(pageList);
    }
    /**
     * 列表查询
     *
     * @param clbSubjectHitwordsMap
     * @param req
     * @return
     */
    @ApiOperation(value="专题命中词-列表查询", notes="专题命中词-列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ClbSubjectHitwordsMap clbSubjectHitwordsMap,
                                   HttpServletRequest req) {
        LambdaQueryWrapper<ClbSubjectHitwordsMap> queryWrapper = Wrappers.<ClbSubjectHitwordsMap>lambdaQuery();
        queryWrapper.orderByDesc(ClbSubjectHitwordsMap::getCreateTime);
        queryWrapper.eq(StrUtil.isNotBlank(clbSubjectHitwordsMap.getSubjectId()),ClbSubjectHitwordsMap::getSubjectId,clbSubjectHitwordsMap.getSubjectId());
        queryWrapper.like(StrUtil.isNotBlank(clbSubjectHitwordsMap.getWordName()),ClbSubjectHitwordsMap::getWordName,clbSubjectHitwordsMap.getWordName());
        List<ClbSubjectHitwordsMap> list = clbSubjectHitwordsMapService.list(queryWrapper);
        return Result.OK(list);
    }

    /**
     * 添加
     *
     * @param clbSubjectHitwordsMap
     * @return
     */
    @ApiOperation(value="专题命中词-添加", notes="专题命中词-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ClbSubjectHitwordsMap clbSubjectHitwordsMap) {
        if (StrUtil.isBlank(clbSubjectHitwordsMap.getSubjectId())){
            return Result.FAIL("请选择专题");
        }
        if (StrUtil.isBlank(clbSubjectHitwordsMap.getWordName())){
            return Result.FAIL("请输入词名");
        }
        if (clbSubjectHitwordsMap.getWordName().length()> 100){
            return Result.FAIL("词语名称输入过长");
        }
        List<ClbSubjectHitwordsMap> list = clbSubjectHitwordsMapService.list(Wrappers.<ClbSubjectHitwordsMap>lambdaQuery()
                .eq(ClbSubjectHitwordsMap::getSubjectId, clbSubjectHitwordsMap.getSubjectId())
                .eq(ClbSubjectHitwordsMap::getWordName, clbSubjectHitwordsMap.getWordName()));
        if (CollectionUtil.isNotEmpty(list)){
            return Result.FAIL("该词名已存在");
        }

        clbSubjectHitwordsMapService.save(clbSubjectHitwordsMap);
        return Result.OK(clbSubjectHitwordsMap);
    }

    /**
     * 编辑
     *
     * @param clbSubjectHitwordsMap
     * @return
     */
    @ApiOperation(value="专题命中词-编辑", notes="专题命中词-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ClbSubjectHitwordsMap clbSubjectHitwordsMap) {
        this.delete(clbSubjectHitwordsMap.getId());
        clbSubjectHitwordsMap.setId(null);
        this.add(clbSubjectHitwordsMap);
        return Result.OK(clbSubjectHitwordsMap);
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @ApiOperation(value="专题命中词-通过id删除", notes="专题命中词-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name="id",required=true) String id) {
        if (StrUtil.isBlank(id)){
            return Result.FAIL("请选择要删除的对象");
        }
        List<ClbSubjectHitwordsMap> clbSubjectHitwordsMaps = clbSubjectHitwordsMapService.listByIds(Arrays.asList(id));
        clbSubjectHitwordsMapService.removeById(id);
        //调用删除es数据接口
        clbSubjectHitwordsMapService.delEs(clbSubjectHitwordsMaps);
        return Result.OK();
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value="专题命中词-批量删除", notes="专题命中词-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
        if (StrUtil.isBlank(ids)){
            return Result.FAIL("请选择要删除的对象");
        }
        List<String> list = Arrays.asList(ids.split(","));
        List<ClbSubjectHitwordsMap> clbSubjectHitwordsMaps = clbSubjectHitwordsMapService.listByIds(list);
        this.clbSubjectHitwordsMapService.removeByIds(list);
        //调用删除es数据接口
        clbSubjectHitwordsMapService.delEs(clbSubjectHitwordsMaps);

        return Result.OK();
    }



    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @ApiOperation(value="专题命中词-通过id查询", notes="专题命中词-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name="id",required=false) String id) {
        if (StrUtil.isBlank(id)){
            return Result.OK();
        }
        ClbSubjectHitwordsMap clbSubjectHitwordsMap = clbSubjectHitwordsMapService.getById(id);
        return Result.OK(clbSubjectHitwordsMap);
    }
}
