package com.zzsn.event.service;


import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.vo.CoOccurrenceVO;
import com.zzsn.event.vo.CountVO;
import com.zzsn.event.vo.EventContextVO;
import com.zzsn.event.vo.PropagationPathVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lkg
 * @description: 专题分析
 * @date 2022/7/20 11:25
 */
public interface AnalysisService {

    /**
     * 事件脉络
     *
     * @param eventId 事件id
     * @param fakeNum 专题事件脉络展示 伪事件脉络 的资讯数量阈值
     * @return java.util.List<com.zzsn.subjectAnalysis.entity.SubjectAnalysis>
     */
    List<SubjectAnalysis> eventContext(String eventId, int fakeNum);

    /**
     * 事件脉络-新版
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/7
     */
    List<JSONObject> eventContext(String eventId);

    /**
     * 词云
     *
     * @param eventId   事件id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param size      返回热词个数
     * @author lkg
     * @date 2025/7/7
     */
    List<CountVO> wordCloud(String eventId, String startTime, String endTime, Integer size);

    /**
     * 关键词时间趋势
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/9
     */
    List<CountVO> wordTrend(String eventId, String startTime, String endTime);

    /**
     * 关键词共现
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/9
     */
    List<CoOccurrenceVO> coOccurrence(String eventId, String startTime, String endTime);

    /**
     * 传播路径
     *
     * @param eventId 事件id
     * @return com.zzsn.subjectAnalysis.vo.PropagationPathVo
     */
    PropagationPathVo propagationPath(String eventId);

    /**
     * 影响评估
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/17
     */
    Object impactAssessment(String eventId,String startTime,String endTime);

    /**
     * 决策建议
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/17
     */
    Object measureSuggest(String eventId,String startTime,String endTime);

    /**
     * 知识词条
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/17
     */
    Object knowledgeEntry(String eventId,String startTime,String endTime);

    /**
     * 企业案例
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/17
     */
    Object enterpriseCase(String eventId,String startTime,String endTime);

    /**
     * 各国政策
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/17
     */
    Object countryPolicy(String eventId,String startTime,String endTime);

    /**
     * 本国类似事件
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/17
     */
    Object domesticSimilarEvent(String eventId,String startTime,String endTime);

    /**
     * 各国类似事件
     *
     * @param eventId 事件id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @author lkg
     * @date 2025/7/17
     */
    Object foreignSimilarEvent(String eventId,String startTime,String endTime);

    /**
     * 重新生成
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/7
     */
    void regenerate(String eventId);
}
