package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SysBaseLabelType;
import com.zzsn.event.mapper.SysBaseLabelTypeMapper;
import com.zzsn.event.service.SysBaseLabelTypeService;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.vo.LabelTypeVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 标签类别
 * @Author: jeecg-boot
 * @Date:   2022-05-12
 * @Version: V1.0
 */
@Service
public class SysBaseLabelTypeServiceImpl extends ServiceImpl<SysBaseLabelTypeMapper, SysBaseLabelType> implements SysBaseLabelTypeService {

    @Override
    public List<String> belowList(String id) {
        List<LabelTypeVO> labelTypeVOS = baseMapper.labelTypeList(null);
        return TreeUtil.belowList(labelTypeVOS, id,true);
    }

    @Override
    public List<LabelTypeVO> labelTypeTree(String labelType) {
        List<LabelTypeVO> labelTypeVOS = baseMapper.labelTypeList(labelType);
        return TreeUtil.tree(labelTypeVOS,ROOT_ID);
    }
}
