package com.zzsn.event.controller;

import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.service.SubjectService;
import com.zzsn.event.service.SubjectSimpleService;
import com.zzsn.event.vo.SearchWordVO;
import com.zzsn.event.vo.SubjectDetailVO;
import com.zzsn.event.vo.SubjectSimpleVO;
import com.zzsn.event.xxljob.service.IXxlJobInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 专题管理流程简化版
 *
 * @author lkg
 * @date 2025/1/9
 */@Slf4j
@RestController
@RequestMapping("/subject/simple")
public class SubjectSimpleController {

    @Autowired
    private SubjectSimpleService subjectSimpleService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private IXxlJobInfoService xxlJobInfoService;

    /**
     * 创建专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/createSubject")
    public Result<?> createSubject(@RequestBody SubjectSimpleVO subjectSimpleVO) {
        Subject subject = subjectSimpleService.createSubject(subjectSimpleVO);
        //插入xxlJob
        xxlJobInfoService.subjectInsert(subject);
        return Result.OK(subject.getId());
    }

    /**
     * 编辑专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/editSubject")
    public Result<?> editSubject(@RequestBody SubjectSimpleVO subjectSimpleVO) {
        subjectSimpleService.editSubject(subjectSimpleVO);
        return Result.OK();
    }

    /**
     * 专题详情(包含样例文章以及关键词)
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/9
     */
    @GetMapping("/queryInfo")
    public Result<?> queryInfo(@RequestParam String subjectId){
        SubjectDetailVO subjectDetailVO = subjectService.queryInfo(subjectId);
        List<SearchWordVO> list = subjectSimpleService.subjectBindWordInfo(subjectId);
        subjectDetailVO.setKeywords(list);
        return Result.OK(subjectDetailVO);
    }
}
