package com.zzsn.event.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.EventContext;
import com.zzsn.event.mapper.EventContextMapper;
import com.zzsn.event.service.EventContextService;
import com.zzsn.event.util.CodeGenerateUtil;
import com.zzsn.event.vo.EventContextModifyVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.ConcurrentModel;

import java.util.*;
import java.util.stream.Collectors;

/**
* @author lenovo
* @description 针对表【event_context(事件脉络表)】的数据库操作Service实现
* @createDate 2025-07-14 18:05:06
*/
@Service
public class EventContextServiceImpl extends ServiceImpl<EventContextMapper, EventContext> implements EventContextService{

    @Autowired
    private CodeGenerateUtil codeGenerateUtil;

    @Override
    public List<Map<String, Object>> eventContext(String eventId) {
        List<Map<String, Object>> dataList = new ArrayList<>();
        LambdaQueryWrapper<EventContext> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventContext::getEventId, eventId).orderByDesc(EventContext::getPublishDate)
                .orderByDesc(EventContext::getSortNumber);
        List<EventContext> eventContexts = baseMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(eventContexts)) {
            List<EventContext> keyNodeList = eventContexts.stream()
                    .filter(eventContext -> eventContext.getYnKeyNode() == 1).collect(Collectors.toList());
            keyNodeList.sort((p1,p2) ->{
                String publishDate = p1.getPublishDate();
                String publishDate2 = p2.getPublishDate();
                int compare = DateUtil.parse(publishDate2).compareTo(DateUtil.parse(publishDate));
                if (compare != 0) {
                    return compare;
                }
                return p2.getSortNumber() - p1.getSortNumber();
            });
            for (EventContext eventContext : keyNodeList) {
                Map<String,Object> map = new HashMap<>();
                List<EventContext> childList = eventContexts.stream().filter(e -> e.getParentId().equals(eventContext.getId())).collect(Collectors.toList());
                map.put("keyNode",eventContext);
                map.put("dataList",childList);
                map.put("count",childList.size());
                dataList.add(map);
            }
        }
        return dataList;
    }

    @Override
    @Transactional
    public void eventContextModify(EventContextModifyVO eventContextModifyVO) {
        EventContext keyNode = eventContextModifyVO.getKeyNode();
        String parentId = null;
        String eventId = eventContextModifyVO.getEventId();
        Integer maxSortNumber = this.getMaxSortNumber(eventId);
        if (keyNode != null) {
            String id = keyNode.getId();
            keyNode.setCreateWay(2);
            if (StringUtils.isEmpty(id)) {
                maxSortNumber = maxSortNumber + 1;
                keyNode.setSortNumber(maxSortNumber);
                keyNode.setParentId("0");
                keyNode.setEventId(eventId);
                keyNode.setYnKeyNode(1);
                keyNode.setUniqueCode(codeGenerateUtil.geneCodeNo("CONTEXT_KEY_NODE"));
                baseMapper.insert(keyNode);
                parentId = keyNode.getId();
            } else {
                baseMapper.updateById(keyNode);
            }
        }
        List<EventContext> saveList = eventContextModifyVO.getSaveList();
        if (CollectionUtils.isNotEmpty(saveList)) {
            for (int i = 0; i < saveList.size(); i++) {
                EventContext eventContext = saveList.get(i);
                if (parentId != null) {
                    eventContext.setParentId(parentId);
                }
                eventContext.setCreateWay(2);
                eventContext.setEventId(eventId);
                eventContext.setSortNumber(maxSortNumber + i + 1);
            }
            this.saveBatch(saveList);
        }
        List<EventContext> updateList = eventContextModifyVO.getUpdateList();
        if (CollectionUtils.isNotEmpty(updateList)) {
            updateList.forEach(e->e.setCreateWay(2));
            this.updateBatchById(updateList);
        }
    }

    @Override
    public List<EventContext> keNodeList(String eventId) {
        LambdaQueryWrapper<EventContext> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventContext::getEventId, eventId)
                .eq(EventContext::getYnKeyNode, 1)
                .orderByDesc(EventContext::getPublishDate)
                .orderByDesc(EventContext::getSortNumber);
        return baseMapper.selectList(queryWrapper);
    }

    @Override
    public Page<EventContext> contextArticleList(String eventId, String keyNodeId, Integer pageNo, Integer pageSize) {
        Page<EventContext> page = new Page<>(pageNo, pageSize);
        LambdaQueryWrapper<EventContext> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventContext::getEventId, eventId)
                .eq(EventContext::getParentId, keyNodeId)
                .orderByDesc(EventContext::getPublishDate)
                .orderByDesc(EventContext::getSortNumber);
        return baseMapper.selectPage(page,queryWrapper);
    }

    @Override
    public Integer getMaxSortNumber(String eventId) {
        return baseMapper.getMaxSortNumber(eventId);
    }
}




