package com.zzsn.event.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.entity.SubjectStatisticInfo;
import com.zzsn.event.service.SubjectService;
import com.zzsn.event.service.SubjectStatisticInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * 专题统计信息任务
 *
 * @author lkg
 * @date 2025/3/25
 */
@Slf4j
@Component
public class SubjectStatisticTask {

    @Autowired
    private SubjectService subjectService;
    @Autowired
    private SubjectStatisticInfoService subjectStatisticInfoService;

    @Value("${scheduling.yjzxEnable:false}")
    Boolean yjzxEnable;

    @Scheduled(cron = "0 30 0 * * ?")
    public void statistic() {
        if(yjzxEnable){
            return;
        }
        LambdaQueryWrapper<Subject> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(Subject::getId).eq(Subject::getSubjectType, 1);
        List<Subject> list = subjectService.list(queryWrapper);
        for (Subject subject : list) {
            CompletableFuture.runAsync(() ->{
                String subjectId = subject.getId();
                try {
                    List<String> subjectIds = new ArrayList<>();
                    subjectIds.add(subjectId);
                    List<SubjectStatisticInfo> subjectStatisticInfos = subjectService.statisticInfo(subjectIds);
                    SubjectStatisticInfo statisticInfo = subjectStatisticInfos.get(0);
                    LambdaQueryWrapper<SubjectStatisticInfo> query = Wrappers.lambdaQuery();
                    query.eq(SubjectStatisticInfo::getSubjectId, subjectId);
                    SubjectStatisticInfo one = subjectStatisticInfoService.getOne(query);
                    if (one == null) {
                        statisticInfo.setCreateTime(new Date());
                        subjectStatisticInfoService.save(statisticInfo);
                    } else {
                        statisticInfo.setId(one.getId());
                        statisticInfo.setUpdateTime(new Date());
                        subjectStatisticInfoService.updateById(statisticInfo);
                    }
                    log.info("专题-{},统计信息任务完成",subjectId);
                } catch (Exception e) {
                    log.info("专题-{},统计信息任务异常:{}",subjectId,e.getMessage());
                }
            });
        }
        log.info("专题统计信息任务完成");
    }
}
