package com.zzsn.event.service;

import com.zzsn.event.entity.EventLlmConfig;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
* @author lenovo
* @description 针对表【event_llm_config(事件大模型信息配置表)】的数据库操作Service
* @createDate 2025-07-21 14:17:40
*/
public interface EventLlmConfigService extends IService<EventLlmConfig> {

    /**
     * 获取事件的大模型配置信息，没有则返回默认的配置信息
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/30
     */
    List<EventLlmConfig> getConfigList(String eventId);

    /**
     * 获取事件下某个栏目的大模型配置信息
     *
     * @param eventId 事件id
     * @param columnCode 栏目id
     * @author lkg
     * @date 2025/7/30
     */
    EventLlmConfig getConfig(String eventId,Integer columnCode);

    /**
     * 批量更新大模型配置
     *
     * @param eventLlmConfigList 配置信息
     * @author lkg
     * @date 2025/7/30
     */
    void modifyBatch(List<EventLlmConfig> eventLlmConfigList);

    /**
     * 更新大模型配置
     *
     * @param eventLlmConfig 配置信息
     * @author lkg
     * @date 2025/7/30
     */
    void modifySingle(EventLlmConfig eventLlmConfig);
}
